/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.spark.DataSourceOptions;
import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBScanBuilder;
import io.tiledb.spark.TileDBWriteBuilder;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class TileDBTable
implements SupportsRead,
SupportsWrite {
    private final StructType schema;
    private final Map<String, String> properties;
    private Set<TableCapability> capabilities;

    public TileDBTable(StructType schema, Map<String, String> properties) {
        this.schema = schema;
        this.properties = properties;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        try {
            TileDBDataSourceOptions tileDBDataSourceOptions = new TileDBDataSourceOptions(new DataSourceOptions((Map<String, String>)options));
            return new TileDBScanBuilder(this.properties, tileDBDataSourceOptions);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new TileDBWriteBuilder(this.properties, info);
    }

    public String name() {
        return this.properties.get("uri");
    }

    public StructType schema() {
        return this.schema;
    }

    public Set<TableCapability> capabilities() {
        if (this.capabilities == null) {
            this.capabilities = new HashSet<TableCapability>();
            this.capabilities.add(TableCapability.BATCH_READ);
            this.capabilities.add(TableCapability.BATCH_WRITE);
            this.capabilities.add(TableCapability.TRUNCATE);
        }
        return this.capabilities;
    }
}

