/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.pogen4selenium.example;

import io.toolisticon.pogen4selenium.api.ActionMoveToAndClick;
import io.toolisticon.pogen4selenium.api.ActionWrite;
import io.toolisticon.pogen4selenium.api.ExtractData;
import io.toolisticon.pogen4selenium.api.ExtractDataValue;
import io.toolisticon.pogen4selenium.api.PageObject;
import io.toolisticon.pogen4selenium.api.PageObjectElement;
import io.toolisticon.pogen4selenium.api.PageObjectParent;
import io.toolisticon.pogen4selenium.api.Pause;
import io.toolisticon.pogen4selenium.api._By;
import io.toolisticon.pogen4selenium.example.TestPagePageObjectImpl;
import io.toolisticon.pogen4selenium.example.TestPageTableEntry;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@PageObject
public interface TestPagePageObject
extends PageObjectParent<TestPagePageObject> {
    public static final String DATA_EXTRACTION_FROM_TABLE_XPATH = "//table//tr[contains(@class,'data')]";
    @PageObjectElement(elementVariableName="inputField", by=_By.ID, value="input_field")
    public static final String INPUT_FIELD_ID = "inputField";
    @PageObjectElement(elementVariableName="counterIncrementButton", by=_By.XPATH, value="//fieldset[@name='counter']/input[@type='button']")
    public static final String COUNTER_INCREMENT_BUTTON_ID = "counterIncrementButton";

    public TestPagePageObject writeToInputField(@ActionWrite(value="inputField") String var1);

    @ExtractDataValue(by=_By.ELEMENT, value="inputField", kind=ExtractDataValue.Kind.ATTRIBUTE, name="value")
    public String readInputFieldValue();

    @ActionMoveToAndClick(value="counterIncrementButton")
    @Pause(value=500L)
    public TestPagePageObject clickCounterIncrementButton();

    @ExtractData(by=_By.XPATH, value="//table//tr[contains(@class,'data')]")
    public List<TestPageTableEntry> getTableEntries();

    @ExtractData(by=_By.XPATH, value="//table//tr[contains(@class,'data')]")
    public TestPageTableEntry getFirstTableEntry();

    @ExtractDataValue(by=_By.XPATH, value="//fieldset[@name='counter']/span[@id='counter']")
    public String getCounter();

    default public String providedGetCounter() {
        return this.getDriver().findElement(By.xpath((String)"//fieldset[@name='counter']/span[@id='counter']")).getText();
    }

    public static TestPagePageObject init(WebDriver driver) {
        driver.get("http://localhost:9090/start");
        return new TestPagePageObjectImpl(driver);
    }
}

