/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.pogen4selenium.example;

import io.toolisticon.pogen4selenium.example.TestPagePageObject;
import io.toolisticon.pogen4selenium.example.TestPageTableEntry;
import io.toolisticon.pogen4selenium.example.TestPageTableEntryImpl;
import io.toolisticon.pogen4selenium.runtime.PageObjectParentImpl;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.How;

public class TestPagePageObjectImpl
extends PageObjectParentImpl<TestPagePageObject>
implements TestPagePageObject {
    protected static final String INPUT_FIELD_LOCATION_ID = "input_field";
    protected static final String COUNTER_INCREMENT_BUTTON_LOCATION_XPATH = "//fieldset[@name='counter']/input[@type='button']";
    @FindBy(how=How.ID, using="input_field")
    protected WebElement inputFieldElement;
    @FindBy(how=How.XPATH, using="//fieldset[@name='counter']/input[@type='button']")
    protected WebElement counterIncrementButtonElement;

    public TestPagePageObjectImpl(WebDriver driver) {
        super(driver);
    }

    public TestPagePageObject verify() {
        this.waitForElementToBePresent(INPUT_FIELD_LOCATION_ID);
        this.waitForElementToBePresent(COUNTER_INCREMENT_BUTTON_LOCATION_XPATH);
        return this;
    }

    @Override
    public TestPagePageObject writeToInputField(String value) {
        this.pause(Duration.ofMillis(0L));
        this.writeToElement(this.inputFieldElement, value);
        return (TestPagePageObject)new TestPagePageObjectImpl(this.getDriver()).pause(Duration.ofMillis(0L));
    }

    @Override
    public TestPagePageObject clickCounterIncrementButton() {
        this.pause(Duration.ofMillis(0L));
        new Actions(this.getDriver()).moveToElement(this.counterIncrementButtonElement).pause(300L).click().build().perform();
        return (TestPagePageObject)new TestPagePageObjectImpl(this.getDriver()).pause(Duration.ofMillis(500L));
    }

    @Override
    public String getCounter() {
        this.pause(Duration.ofMillis(0L));
        return this.getDriver().findElement(By.xpath((String)"//fieldset[@name='counter']/span[@id='counter']")).getText();
    }

    @Override
    public TestPageTableEntry getFirstTableEntry() {
        this.pause(Duration.ofMillis(0L));
        return new TestPageTableEntryImpl(this.getDriver().findElement(By.xpath((String)"//table//tr[contains(@class,'data')]")));
    }

    @Override
    public String readInputFieldValue() {
        this.pause(Duration.ofMillis(0L));
        return this.inputFieldElement.getAttribute("value");
    }

    @Override
    public List<TestPageTableEntry> getTableEntries() {
        this.pause(Duration.ofMillis(0L));
        return this.getDriver().findElements(By.xpath((String)"//table//tr[contains(@class,'data')]")).stream().map(TestPageTableEntryImpl::new).collect(Collectors.toList());
    }
}

