/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.binding.httpclient;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpHeaderTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.params.HttpClientParams;

public class TraceeHttpClientDecorator
extends HttpClient {
    private final HttpClient delegate;
    private final TraceeBackend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public static HttpClient wrap(HttpClient httpClient) {
        return TraceeHttpClientDecorator.wrap(httpClient, "default");
    }

    public static HttpClient wrap(HttpClient httpClient, String profile) {
        if (httpClient instanceof TraceeHttpClientDecorator) {
            return httpClient;
        }
        return new TraceeHttpClientDecorator(httpClient, profile);
    }

    TraceeHttpClientDecorator(HttpClient delegate, TraceeBackend backend, HttpHeaderTransport transportSerialization, String profile) {
        this.delegate = delegate;
        this.backend = backend;
        this.transportSerialization = transportSerialization;
        this.profile = profile;
    }

    TraceeHttpClientDecorator(HttpClient delegate, TraceeBackend backend, String profile) {
        this(delegate, backend, new HttpHeaderTransport(), profile);
    }

    public TraceeHttpClientDecorator(HttpClient delegate, String profile) {
        this(delegate, Tracee.getBackend(), profile);
    }

    public int executeMethod(HttpMethod method) throws IOException, HttpException {
        return this.executeMethod(null, method, null);
    }

    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod method) throws IOException, HttpException {
        return this.executeMethod(hostConfiguration, method, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeMethod(HostConfiguration hostconfig, HttpMethod method, HttpState state) throws IOException, HttpException {
        this.preRequest(method);
        try {
            int result = this.delegate.executeMethod(hostconfig, method, state);
            this.postResponse(method);
            int n = result;
            return n;
        }
        finally {
            this.cancel();
        }
    }

    private void cancel() {
    }

    private void preRequest(HttpMethod httpMethod) {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingRequest)) {
            Map filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceeFilterConfiguration.Channel.OutgoingRequest);
            httpMethod.setRequestHeader("TPIC", this.transportSerialization.render(filteredParams));
        }
    }

    private void postResponse(HttpMethod httpMethod) {
        if (!httpMethod.isRequestSent()) {
            return;
        }
        Header[] responseHeaders = httpMethod.getResponseHeaders("TPIC");
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (responseHeaders != null && responseHeaders.length > 0 && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingResponse)) {
            ArrayList<String> stringTraceeHeaders = new ArrayList<String>();
            for (Header header : responseHeaders) {
                stringTraceeHeaders.add(header.getValue());
            }
            this.backend.putAll(filterConfiguration.filterDeniedParams(this.transportSerialization.parse(stringTraceeHeaders), TraceeFilterConfiguration.Channel.IncomingResponse));
        }
    }

    public synchronized HttpState getState() {
        return this.delegate.getState();
    }

    public synchronized void setState(HttpState state) {
        this.delegate.setState(state);
    }

    public synchronized void setStrictMode(boolean strictMode) {
        this.delegate.setStrictMode(strictMode);
    }

    public synchronized boolean isStrictMode() {
        return this.delegate.isStrictMode();
    }

    public synchronized void setTimeout(int newTimeoutInMilliseconds) {
        this.delegate.setTimeout(newTimeoutInMilliseconds);
    }

    public synchronized void setHttpConnectionFactoryTimeout(long timeout) {
        this.delegate.setHttpConnectionFactoryTimeout(timeout);
    }

    public synchronized void setConnectionTimeout(int newTimeoutInMilliseconds) {
        this.delegate.setConnectionTimeout(newTimeoutInMilliseconds);
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public synchronized HostConfiguration getHostConfiguration() {
        return this.delegate.getHostConfiguration();
    }

    public synchronized void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.delegate.setHostConfiguration(hostConfiguration);
    }

    public synchronized HttpConnectionManager getHttpConnectionManager() {
        return this.delegate.getHttpConnectionManager();
    }

    public synchronized void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.delegate.setHttpConnectionManager(httpConnectionManager);
    }

    public HttpClientParams getParams() {
        return this.delegate.getParams();
    }

    public void setParams(HttpClientParams params) {
        this.delegate.setParams(params);
    }
}

