/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.binding.springrabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.Utilities;
import io.tracee.configuration.TraceeFilterConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;

public class TraceeMessagePropertiesConverter
extends DefaultMessagePropertiesConverter {
    private final TraceeBackend backend;
    private final String profile;

    public TraceeMessagePropertiesConverter() {
        this(Tracee.getBackend(), "default");
    }

    public TraceeMessagePropertiesConverter(String profile) {
        this(Tracee.getBackend(), profile);
    }

    TraceeMessagePropertiesConverter(TraceeBackend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
        Map<String, String> traceeContextMap;
        MessageProperties messageProperties = super.toMessageProperties(source, envelope, charset);
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.AsyncProcess) && (traceeContextMap = this.transformToTraceeContextMap((Map)messageProperties.getHeaders().get("TPIC"))) != null && !traceeContextMap.isEmpty()) {
            this.backend.putAll(filterConfiguration.filterDeniedParams(traceeContextMap, TraceeFilterConfiguration.Channel.AsyncProcess));
        }
        Utilities.generateInvocationIdIfNecessary((TraceeBackend)this.backend);
        return messageProperties;
    }

    private Map<String, String> transformToTraceeContextMap(Map<String, ?> tpicMessageHeader) {
        HashMap<String, String> traceeContext = new HashMap<String, String>();
        if (tpicMessageHeader != null) {
            for (Map.Entry<String, ?> stringObjectEntry : tpicMessageHeader.entrySet()) {
                traceeContext.put(stringObjectEntry.getKey(), String.valueOf(stringObjectEntry.getValue()));
            }
        }
        return traceeContext;
    }

    public AMQP.BasicProperties fromMessageProperties(MessageProperties source, String charset) {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.AsyncDispatch)) {
            Map filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceeFilterConfiguration.Channel.AsyncDispatch);
            source.getHeaders().put("TPIC", filteredParams);
        }
        return super.fromMessageProperties(source, charset);
    }
}

