/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.contextlogger.contextprovider.aspectj;

import io.tracee.contextlogger.MessagePrefixProvider;
import io.tracee.contextlogger.TraceeContextLogger;
import io.tracee.contextlogger.api.ContextLogger;
import io.tracee.contextlogger.api.ErrorMessage;
import io.tracee.contextlogger.api.internal.MessageLogLevel;
import io.tracee.contextlogger.contextprovider.aspectj.Watchdog;
import io.tracee.contextlogger.contextprovider.aspectj.contextprovider.WatchdogDataWrapper;
import io.tracee.contextlogger.contextprovider.aspectj.util.WatchdogUtils;
import io.tracee.contextlogger.contextprovider.core.CoreImplicitContextProviders;
import io.tracee.contextlogger.contextprovider.core.tracee.TraceeMessage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class WatchdogAspect {
    private static final Logger logger = LoggerFactory.getLogger(WatchdogAspect.class);
    private final boolean active;

    public WatchdogAspect() {
        this(Boolean.valueOf(System.getProperty("Watchdog.isActive", "true")));
    }

    WatchdogAspect(boolean active) {
        this.active = active;
    }

    @Pointcut(value="(execution(* *(..)) && @annotation(io.tracee.contextlogger.contextprovider.aspectj.Watchdog))")
    void withinWatchdogAnnotatedMethods() {
    }

    @Pointcut(value="within(@io.tracee.contextlogger.contextprovider.aspectj.Watchdog *)")
    void withinClassWithWatchdogAnnotation() {
    }

    @Pointcut(value="execution(public * *(..))")
    void publicMethods() {
    }

    @Around(value="withinWatchdogAnnotatedMethods() || (publicMethods() && withinClassWithWatchdogAnnotation()) ")
    public Object guard(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Throwable e) {
            if (this.active) {
                try {
                    Watchdog watchdog = WatchdogUtils.getWatchdogAnnotation(proceedingJoinPoint);
                    if (WatchdogUtils.checkProcessWatchdog(watchdog, proceedingJoinPoint, e)) {
                        String annotatedId = watchdog.id().isEmpty() ? null : watchdog.id();
                        this.sendErrorReportToConnectors(proceedingJoinPoint, annotatedId, e);
                    }
                }
                catch (Throwable error) {
                    logger.error("error", error);
                }
            }
            throw e;
        }
    }

    void sendErrorReportToConnectors(ProceedingJoinPoint proceedingJoinPoint, String annotatedId, Throwable e) {
        ErrorMessage errorMessage = WatchdogUtils.getErrorMessageAnnotation(proceedingJoinPoint);
        if (errorMessage == null) {
            ((ContextLogger)TraceeContextLogger.create().enforceOrder().apply()).logWithPrefixedMessage(MessagePrefixProvider.provideLogMessagePrefix((MessageLogLevel)MessageLogLevel.ERROR, Watchdog.class), new Object[]{CoreImplicitContextProviders.COMMON, CoreImplicitContextProviders.TRACEE, WatchdogDataWrapper.wrap(annotatedId, proceedingJoinPoint), e});
        } else {
            ((ContextLogger)TraceeContextLogger.create().enforceOrder().apply()).logWithPrefixedMessage(MessagePrefixProvider.provideLogMessagePrefix((MessageLogLevel)MessageLogLevel.ERROR, Watchdog.class), new Object[]{TraceeMessage.wrap((Object)errorMessage.value()), CoreImplicitContextProviders.COMMON, CoreImplicitContextProviders.TRACEE, WatchdogDataWrapper.wrap(annotatedId, proceedingJoinPoint), e});
        }
    }
}

