/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.contextlogger.contextprovider.aspectj.util;

import io.tracee.contextlogger.api.ErrorMessage;
import io.tracee.contextlogger.contextprovider.aspectj.Watchdog;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public final class WatchdogUtils {
    private WatchdogUtils() {
    }

    public static Watchdog getWatchdogAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Watchdog methodAnnotation = methodSignature.getMethod().getAnnotation(Watchdog.class);
        if (methodAnnotation != null) {
            return methodAnnotation;
        }
        return proceedingJoinPoint.getSignature().getDeclaringType().getAnnotation(Watchdog.class);
    }

    public static ErrorMessage getErrorMessageAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        ErrorMessage methodAnnotation = methodSignature.getMethod().getAnnotation(ErrorMessage.class);
        if (methodAnnotation != null) {
            return methodAnnotation;
        }
        return null;
    }

    public static boolean checkIfMethodThrowsContainsPassedException(ProceedingJoinPoint proceedingJoinPoint, Throwable thrownException) {
        if (proceedingJoinPoint == null || thrownException == null) {
            return false;
        }
        Class[] throwsClassesFromMethodSignature = WatchdogUtils.getDefinedThrowsFromMethodSignature(proceedingJoinPoint);
        return WatchdogUtils.checkClassIsDefinedInThrowsException(throwsClassesFromMethodSignature, thrownException);
    }

    public static boolean checkClassIsDefinedInThrowsException(Class[] classes, Throwable thrownException) {
        if (classes == null || thrownException == null) {
            return false;
        }
        for (Class clazz : classes) {
            if (!clazz.isInstance(thrownException)) continue;
            return true;
        }
        return false;
    }

    public static Class[] getDefinedThrowsFromMethodSignature(ProceedingJoinPoint proceedingJoinPoint) {
        if (proceedingJoinPoint == null) {
            return new Class[0];
        }
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        return methodSignature.getMethod().getExceptionTypes();
    }

    public static boolean checkProcessWatchdog(Watchdog watchdogAnnotation, ProceedingJoinPoint proceedingJoinPoint, Throwable throwable) {
        if (watchdogAnnotation != null && watchdogAnnotation.isActive()) {
            boolean throwableIsPartOfThrowsDeclaration = WatchdogUtils.checkIfMethodThrowsContainsPassedException(proceedingJoinPoint, throwable);
            if (!watchdogAnnotation.suppressThrowsExceptions() || watchdogAnnotation.suppressThrowsExceptions() && !throwableIsPartOfThrowsDeclaration) {
                return true;
            }
        }
        return false;
    }
}

