/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.contextlogger.contextprovider.jaxws;

import io.tracee.contextlogger.MessagePrefixProvider;
import io.tracee.contextlogger.TraceeContextLogger;
import io.tracee.contextlogger.api.ContextLogger;
import io.tracee.contextlogger.api.internal.MessageLogLevel;
import io.tracee.contextlogger.contextprovider.core.CoreImplicitContextProviders;
import io.tracee.contextlogger.contextprovider.jaxws.contextprovider.JaxWsWrapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTraceeErrorLoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTraceeErrorLoggingHandler.class);
    protected static final ThreadLocal<String> THREAD_LOCAL_SOAP_MESSAGE_STR = new ThreadLocal();

    AbstractTraceeErrorLoggingHandler() {
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        if (this.isOutgoing((MessageContext)context)) {
            this.handleOutgoing(context);
        } else {
            this.handleIncoming(context);
        }
        return true;
    }

    public final boolean handleFault(SOAPMessageContext context) {
        SOAPMessage soapMessage = context.getMessage();
        ((ContextLogger)TraceeContextLogger.create().enforceOrder().apply()).logWithPrefixedMessage(MessagePrefixProvider.provideLogMessagePrefix((MessageLogLevel)MessageLogLevel.ERROR, (String)"JAX-WS"), new Object[]{CoreImplicitContextProviders.COMMON, CoreImplicitContextProviders.TRACEE, JaxWsWrapper.wrap(THREAD_LOCAL_SOAP_MESSAGE_STR.get(), this.convertSoapMessageAsString(soapMessage))});
        return true;
    }

    public void close(MessageContext context) {
        THREAD_LOCAL_SOAP_MESSAGE_STR.remove();
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    String convertSoapMessageAsString(SOAPMessage soapMessage) {
        if (soapMessage == null) {
            return "null";
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)os);
            return new String(os.toByteArray(), this.determineMessageEncoding(soapMessage));
        }
        catch (Exception e) {
            logger.error("Couldn't create string representation of soapMessage: " + soapMessage.toString());
            return "ERROR";
        }
    }

    Charset determineMessageEncoding(SOAPMessage soapMessage) {
        try {
            Object encProp = soapMessage.getProperty("javax.xml.soap.character-set-encoding");
            if (encProp != null) {
                return Charset.forName(String.valueOf(encProp));
            }
            return Charset.forName("UTF-8");
        }
        catch (Exception e) {
            return Charset.forName("UTF-8");
        }
    }

    protected void storeMessageInThreadLocal(SOAPMessageContext context) {
        SOAPMessage soapMessage = context.getMessage();
        if (soapMessage != null) {
            String soapMessageAsString = this.convertSoapMessageAsString(soapMessage);
            THREAD_LOCAL_SOAP_MESSAGE_STR.set(soapMessageAsString);
        }
    }

    protected abstract void handleIncoming(SOAPMessageContext var1);

    protected abstract void handleOutgoing(SOAPMessageContext var1);

    private boolean isOutgoing(MessageContext messageContext) {
        Object outboundBoolean = messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        return outboundBoolean != null && (Boolean)outboundBoolean != false;
    }
}

