/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.contextlogger.contextprovider.jaxws;

import io.tracee.contextlogger.contextprovider.jaxws.TraceeClientErrorLoggingHandler;
import io.tracee.contextlogger.contextprovider.jaxws.TraceeClientHandlerResolverBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceeClientHandlerResolver
implements HandlerResolver,
TraceeClientHandlerResolverBuilder {
    private final Logger logger = LoggerFactory.getLogger(TraceeClientHandlerResolver.class);
    private final List<Handler> handlerList = new ArrayList<Handler>();

    public final List<Handler> getHandlerChain(PortInfo portInfo) {
        return this.handlerList;
    }

    @Override
    public HandlerResolver build() {
        this.handlerList.add((Handler)new TraceeClientErrorLoggingHandler());
        return this;
    }

    @Override
    public TraceeClientHandlerResolverBuilder add(SOAPHandler<SOAPMessageContext> handler) {
        if (handler != null) {
            this.handlerList.add((Handler)handler);
        }
        return this;
    }

    @Override
    public TraceeClientHandlerResolverBuilder add(Class<? extends SOAPHandler<SOAPMessageContext>> handlerType) {
        if (handlerType != null) {
            try {
                SOAPHandler<SOAPMessageContext> handler = handlerType.newInstance();
                this.handlerList.add((Handler)handler);
            }
            catch (Exception e) {
                this.logger.error("HandlerResolver of type '" + handlerType.getCanonicalName() + "' couldn't be added to HandlerResolver", (Throwable)e);
            }
        }
        return this;
    }

    public static TraceeClientHandlerResolverBuilder buildHandlerResolver() {
        return new TraceeClientHandlerResolver();
    }

    public static HandlerResolver createSimpleHandlerResolver() {
        return new TraceeClientHandlerResolver().build();
    }
}

