/*
 * Decompiled with CFR 0.152.
 */
package io.tracee;

import io.tracee.BackendProviderSet;
import io.tracee.spi.TraceeBackendProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;

class BackendProviderResolver {
    private static volatile Map<ClassLoader, Set<TraceeBackendProvider>> providersPerClassloader = new WeakHashMap<ClassLoader, Set<TraceeBackendProvider>>();

    BackendProviderResolver() {
    }

    public Set<TraceeBackendProvider> getBackendProviders() {
        Map<ClassLoader, Set<TraceeBackendProvider>> cacheCopy = providersPerClassloader;
        Set<TraceeBackendProvider> providerFromContextClassLoader = this.getTraceeProviderFromClassloader(cacheCopy, GetClassLoader.fromContext());
        if (!providerFromContextClassLoader.isEmpty()) {
            return providerFromContextClassLoader;
        }
        return this.getTraceeProviderFromClassloader(cacheCopy, GetClassLoader.fromClass(BackendProviderResolver.class));
    }

    private Set<TraceeBackendProvider> getTraceeProviderFromClassloader(Map<ClassLoader, Set<TraceeBackendProvider>> cacheCopy, ClassLoader classLoader) {
        Set<TraceeBackendProvider> classLoaderProviders = cacheCopy.get(classLoader);
        if (this.isLookupNeeded(classLoaderProviders)) {
            classLoaderProviders = this.loadProviders(classLoader);
            this.updatedCache(classLoader, classLoaderProviders);
        }
        return classLoaderProviders;
    }

    boolean isLookupNeeded(Set<TraceeBackendProvider> classLoaderProviders) {
        return classLoaderProviders == null || !(classLoaderProviders instanceof EmptyBackendProviderSet) && classLoaderProviders.isEmpty();
    }

    private void updatedCache(ClassLoader classLoader, Set<TraceeBackendProvider> provider) {
        WeakHashMap<ClassLoader, Set<TraceeBackendProvider>> copyOnWriteMap = new WeakHashMap<ClassLoader, Set<TraceeBackendProvider>>(providersPerClassloader);
        if (!provider.isEmpty()) {
            copyOnWriteMap.put(classLoader, new BackendProviderSet(provider));
        } else {
            copyOnWriteMap.put(classLoader, new EmptyBackendProviderSet());
        }
        providersPerClassloader = copyOnWriteMap;
    }

    private Set<TraceeBackendProvider> loadProviders(ClassLoader classloader) {
        ServiceLoader<TraceeBackendProvider> loader = ServiceLoader.load(TraceeBackendProvider.class, classloader);
        Iterator<TraceeBackendProvider> providerIterator = loader.iterator();
        HashSet<TraceeBackendProvider> traceeProvider = new HashSet<TraceeBackendProvider>();
        while (providerIterator.hasNext()) {
            try {
                traceeProvider.add(providerIterator.next());
            }
            catch (ServiceConfigurationError e) {}
        }
        return traceeProvider;
    }

    static final class EmptyBackendProviderSet
    extends AbstractSet<TraceeBackendProvider> {
        EmptyBackendProviderSet() {
        }

        @Override
        public Iterator<TraceeBackendProvider> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }

        public static ClassLoader fromContext() {
            return GetClassLoader.doPrivileged(new GetClassLoader(null));
        }

        public static ClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            return GetClassLoader.doPrivileged(new GetClassLoader(clazz));
        }

        private static ClassLoader doPrivileged(GetClassLoader action) {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }
    }
}

