/*
 * Decompiled with CFR 0.152.
 */
package io.tracee;

import io.tracee.spi.TraceeBackendProvider;
import java.lang.ref.SoftReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class BackendProviderSet
extends AbstractSet<TraceeBackendProvider> {
    private Set<SoftReference<TraceeBackendProvider>> values = new HashSet<SoftReference<TraceeBackendProvider>>();
    private boolean valid = true;

    BackendProviderSet(Set<TraceeBackendProvider> elements) {
        this.addAllInternal(elements);
    }

    private void addAllInternal(Collection<TraceeBackendProvider> elements) {
        for (TraceeBackendProvider element : elements) {
            this.values.add(new SoftReference<TraceeBackendProvider>(element));
        }
    }

    @Override
    public Iterator<TraceeBackendProvider> iterator() {
        Collection<TraceeBackendProvider> strongRefList = this.createStrongView(this.values);
        this.determineValidity(strongRefList);
        if (this.valid) {
            return strongRefList.iterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public int size() {
        Collection<TraceeBackendProvider> strongRefList = this.createStrongView(this.values);
        this.determineValidity(strongRefList);
        if (this.valid) {
            return strongRefList.size();
        }
        return 0;
    }

    private void determineValidity(Collection<TraceeBackendProvider> providers) {
        if (!this.valid) {
            return;
        }
        for (TraceeBackendProvider provider : providers) {
            if (provider != null) continue;
            this.valid = false;
        }
    }

    private Collection<TraceeBackendProvider> createStrongView(Collection<SoftReference<TraceeBackendProvider>> providerReferences) {
        ArrayList<TraceeBackendProvider> strongRefs = new ArrayList<TraceeBackendProvider>(providerReferences.size());
        for (SoftReference<TraceeBackendProvider> providerSoftReference : providerReferences) {
            strongRefs.add(providerSoftReference.get());
        }
        return strongRefs;
    }
}

