/*
 * Decompiled with CFR 0.152.
 */
package io.tracee;

import io.tracee.MDCLike;
import io.tracee.TraceeBackend;
import io.tracee.TraceeLoggerFactory;
import io.tracee.configuration.PropertiesBasedTraceeFilterConfiguration;
import io.tracee.configuration.PropertyChain;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.configuration.TraceePropertiesFileLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MDCLikeTraceeBackend
implements TraceeBackend {
    public static final String TRACEE_PROPERTIES_FILE = "META-INF/tracee.properties";
    public static final String TRACEE_DEFAULT_PROPERTIES_FILE = "META-INF/tracee.default.properties";
    private PropertyChain lazyPropertyChain = null;
    private final TraceeLoggerFactory loggerFactory;
    private final MDCLike mdcAdapter;
    private final ThreadLocal<Set<String>> traceeKeys;

    @Override
    public final TraceeFilterConfiguration getConfiguration() {
        if (this.lazyPropertyChain == null) {
            this.lazyPropertyChain = this.loadPropertyChain();
        }
        return new PropertiesBasedTraceeFilterConfiguration(this.lazyPropertyChain);
    }

    @Override
    public final TraceeFilterConfiguration getConfiguration(String profileName) {
        if (this.lazyPropertyChain == null) {
            this.lazyPropertyChain = this.loadPropertyChain();
        }
        return new PropertiesBasedTraceeFilterConfiguration(this.lazyPropertyChain, profileName);
    }

    private PropertyChain loadPropertyChain() {
        try {
            Properties traceeDefaultFileProperties = new TraceePropertiesFileLoader().loadTraceeProperties(TRACEE_DEFAULT_PROPERTIES_FILE);
            Properties traceeFileProperties = new TraceePropertiesFileLoader().loadTraceeProperties(TRACEE_PROPERTIES_FILE);
            return PropertyChain.build(System.getProperties(), traceeFileProperties, traceeDefaultFileProperties);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not load TraceeProperties: " + ioe.getMessage(), ioe);
        }
    }

    protected MDCLikeTraceeBackend(MDCLike mdcAdapter, ThreadLocal<Set<String>> traceeKeys, TraceeLoggerFactory loggerFactory) {
        this.mdcAdapter = mdcAdapter;
        this.traceeKeys = traceeKeys;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public final boolean containsKey(Object key) {
        return key instanceof String && this.traceeKeys.get().contains(key) && this.mdcAdapter.containsKey((String)key);
    }

    @Override
    public final boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("null values are not allowed.");
        }
        for (String key : this.traceeKeys.get()) {
            if (!value.equals(this.mdcAdapter.get(key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int size() {
        return this.traceeKeys.get().size();
    }

    @Override
    public final boolean isEmpty() {
        return this.traceeKeys.get().isEmpty();
    }

    @Override
    public final String get(Object key) {
        if (key instanceof String && this.traceeKeys.get().contains(key)) {
            return this.mdcAdapter.get((String)key);
        }
        return null;
    }

    @Override
    public final Set<String> keySet() {
        return Collections.unmodifiableSet(this.traceeKeys.get());
    }

    @Override
    public final Collection<String> values() {
        ArrayList<String> values = new ArrayList<String>(this.traceeKeys.get().size());
        for (String traceeKey : this.traceeKeys.get()) {
            values.add(this.mdcAdapter.get(traceeKey));
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public final String put(String key, String value) {
        if (key == null) {
            throw new NullPointerException("null keys are not allowed.");
        }
        if (value == null) {
            throw new NullPointerException("null values are not allowed.");
        }
        Set<String> registeredKeys = this.traceeKeys.get();
        if (!registeredKeys.contains(key)) {
            registeredKeys.add(key);
        }
        String current = this.mdcAdapter.get(key);
        this.mdcAdapter.put(key, value);
        return current;
    }

    @Override
    public final String remove(Object key) {
        if (key == null) {
            throw new NullPointerException("null keys are not allowed.");
        }
        if (key instanceof String && this.traceeKeys.get().remove(key)) {
            String current = this.mdcAdapter.get((String)key);
            this.mdcAdapter.remove((String)key);
            return current;
        }
        return null;
    }

    @Override
    public final void clear() {
        Set<String> keys = this.traceeKeys.get();
        for (String s : keys) {
            this.mdcAdapter.remove(s);
        }
        this.traceeKeys.remove();
    }

    @Override
    public final void putAll(Map<? extends String, ? extends String> entries) {
        for (Map.Entry<? extends String, ? extends String> entry : entries.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final Set<Map.Entry<String, String>> entrySet() {
        HashSet<Entry> entries = new HashSet<Entry>();
        for (String traceeKey : this.traceeKeys.get()) {
            entries.add(new Entry(traceeKey));
        }
        return Collections.unmodifiableSet(entries);
    }

    @Override
    public final TraceeLoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    private final class Entry
    implements Map.Entry<String, String> {
        public final String key;

        private Entry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return MDCLikeTraceeBackend.this.get(this.key);
        }

        @Override
        public String setValue(String value) {
            return MDCLikeTraceeBackend.this.put(this.key, value);
        }
    }
}

