/*
 * Decompiled with CFR 0.152.
 */
package io.tracee;

import io.tracee.BackendProviderResolver;
import io.tracee.TraceeBackend;
import io.tracee.TraceeException;
import io.tracee.spi.TraceeBackendProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public final class Tracee {
    private Tracee() {
    }

    public static TraceeBackend getBackend() {
        return Tracee.getBackend(new BackendProviderResolver());
    }

    protected static TraceeBackend getBackend(BackendProviderResolver resolver) {
        Set<TraceeBackendProvider> backendProviders;
        try {
            backendProviders = resolver.getBackendProviders();
        }
        catch (RuntimeException e) {
            throw new TraceeException("Unable to load available backend providers", e);
        }
        if (backendProviders.isEmpty()) {
            throw new TraceeException("Unable to find a TracEE backend provider. Make sure that you have an implementation on the classpath.");
        }
        if (backendProviders.size() > 1) {
            ArrayList providerClasses = new ArrayList(backendProviders.size());
            for (TraceeBackendProvider backendProvider : backendProviders) {
                providerClasses.add(backendProvider.getClass());
            }
            String providerClassNames = Arrays.toString(providerClasses.toArray());
            throw new TraceeException("Multiple TracEE backend providers found. Don't know which one of the following to use: " + providerClassNames);
        }
        return backendProviders.iterator().next().provideBackend();
    }
}

