/*
 * Decompiled with CFR 0.152.
 */
package io.tracee;

import io.tracee.ThreadLocalRandom;
import io.tracee.TraceeBackend;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Utilities {
    private static final char[] ALPHANUMERICS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    private Utilities() {
    }

    public static boolean isNullOrEmptyString(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static String createRandomAlphanumeric(int length) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        char[] randomChars = new char[length];
        for (int i = 0; i < length; ++i) {
            randomChars[i] = ALPHANUMERICS[r.nextInt(ALPHANUMERICS.length)];
        }
        return new String(randomChars);
    }

    public static String createAlphanumericHash(String str, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(str.getBytes(Charset.forName("UTF-8")));
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                if (b < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(b & 0xFF));
            }
            while (sb.length() < length) {
                sb.append(sb.toString());
            }
            return sb.delete(length, sb.length()).toString();
        }
        catch (NoSuchAlgorithmException e) {
            return Utilities.createRandomAlphanumeric(length);
        }
        catch (UnsupportedCharsetException e) {
            return Utilities.createRandomAlphanumeric(length);
        }
    }

    public static void generateRequestIdIfNecessary(TraceeBackend backend) {
        if (backend != null && !backend.containsKey("traceeRequestId") && backend.getConfiguration().shouldGenerateRequestId()) {
            backend.put("traceeRequestId", Utilities.createRandomAlphanumeric(backend.getConfiguration().generatedRequestIdLength()));
        }
    }

    public static void generateSessionIdIfNecessary(TraceeBackend backend, String sessionId) {
        if (backend != null && !backend.containsKey("traceeSessionId") && backend.getConfiguration().shouldGenerateSessionId()) {
            backend.put("traceeSessionId", Utilities.createAlphanumericHash(sessionId, backend.getConfiguration().generatedSessionIdLength()));
        }
    }
}

