/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.configuration;

import io.tracee.Utilities;
import io.tracee.configuration.PropertyChain;
import io.tracee.configuration.TraceeFilterConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PropertiesBasedTraceeFilterConfiguration
implements TraceeFilterConfiguration {
    public static final String TRACEE_CONFIG_PREFIX = "tracee.";
    static final String DEFAULT_PROFILE_PREFIX = "default.";
    public static final String GENERATE_REQUEST_ID = "requestIdLength";
    public static final String GENERATE_SESSION_ID = "sessionIdLength";
    private final PropertyChain propertyChain;
    private final String profileName;

    public PropertiesBasedTraceeFilterConfiguration(PropertyChain propertyChain) {
        this(propertyChain, null);
    }

    public PropertiesBasedTraceeFilterConfiguration(PropertyChain propertyChain, String profileName) {
        this.propertyChain = propertyChain;
        this.profileName = profileName;
    }

    private String getProfiledOrDefaultProperty(String propertyName) {
        String profiledProperty;
        if (this.profileName != null && (profiledProperty = this.propertyChain.getProperty(TRACEE_CONFIG_PREFIX + this.profileName + "." + propertyName)) != null) {
            return profiledProperty;
        }
        return this.propertyChain.getProperty("tracee.default." + propertyName);
    }

    @Override
    public boolean shouldProcessParam(String paramName, TraceeFilterConfiguration.Channel channel) {
        String messageTypePropertyValue = this.getProfiledOrDefaultProperty(channel.name());
        List<String> patterns = this.extractPatterns(messageTypePropertyValue);
        return this.anyPatternMatchesParamName(patterns, paramName);
    }

    @Override
    public boolean shouldProcessContext(TraceeFilterConfiguration.Channel channel) {
        String messageTypePropertyValue = this.getProfiledOrDefaultProperty(channel.name());
        return !Utilities.isNullOrEmptyString(messageTypePropertyValue);
    }

    @Override
    public boolean shouldGenerateRequestId() {
        return this.generatedRequestIdLength() > 0;
    }

    @Override
    public int generatedRequestIdLength() {
        return this.parseIntOrZero(this.getProfiledOrDefaultProperty(GENERATE_REQUEST_ID));
    }

    @Override
    public boolean shouldGenerateSessionId() {
        return this.generatedSessionIdLength() > 0;
    }

    @Override
    public int generatedSessionIdLength() {
        return this.parseIntOrZero(this.getProfiledOrDefaultProperty(GENERATE_SESSION_ID));
    }

    @Override
    public Map<String, String> filterDeniedParams(Map<String, String> unfiltered, TraceeFilterConfiguration.Channel channel) {
        HashMap<String, String> filtered = new HashMap<String, String>(unfiltered.size());
        for (Map.Entry<String, String> entry : unfiltered.entrySet()) {
            if (!this.shouldProcessParam(entry.getKey(), channel)) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    private int parseIntOrZero(String intString) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private boolean anyPatternMatchesParamName(Iterable<String> patterns, String paramName) {
        for (String pattern : patterns) {
            if (!this.patternMatchesParamName(pattern, paramName)) continue;
            return true;
        }
        return false;
    }

    private boolean patternMatchesParamName(String pattern, String paramName) {
        return paramName.matches(pattern);
    }

    private List<String> extractPatterns(String propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        String[] rawPatterns = propertyValue.split(",");
        ArrayList<String> trimmedPatterns = new ArrayList<String>(rawPatterns.length);
        for (String rawPattern : rawPatterns) {
            String trimmedPattern = rawPattern.trim();
            if (trimmedPattern.isEmpty()) continue;
            trimmedPatterns.add(trimmedPattern);
        }
        return trimmedPatterns;
    }
}

