/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.transport;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.tracee.TraceeLogger;
import io.tracee.TraceeLoggerFactory;
import io.tracee.transport.TransportSerialization;
import java.util.Collections;
import java.util.Map;

public class HttpJsonHeaderTransport
implements TransportSerialization<String> {
    private final Gson gson = new Gson();
    private final TraceeLogger logger;

    public HttpJsonHeaderTransport(TraceeLoggerFactory traceeLoggerFactory) {
        this.logger = traceeLoggerFactory.getLogger(HttpJsonHeaderTransport.class);
    }

    @Override
    public final Map<String, String> parse(String serialized) {
        try {
            return (Map)this.gson.fromJson(serialized, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (JsonParseException e) {
            this.logger.debug("Failed to parse header. Ignoring: \"" + serialized + "\"");
            return Collections.emptyMap();
        }
    }

    @Override
    public final String render(Map<String, String> backend) {
        if (backend.isEmpty()) {
            return null;
        }
        return this.gson.toJson(backend);
    }
}

