/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.bigquery.BigQueryPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.sql.SqlExecutor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BigQueryQueryRunner {
    private static final String BIGQUERY_CREDENTIALS_KEY = Objects.requireNonNull(System.getProperty("bigquery.credentials-key"), "bigquery.credentials-key is not set");
    public static final String TPCH_SCHEMA = "tpch";
    public static final String TEST_SCHEMA = "test";

    private BigQueryQueryRunner() {
    }

    public static DistributedQueryRunner createQueryRunner(Map<String, String> extraProperties, Map<String, String> connectorProperties) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)BigQueryQueryRunner.createSession()).setExtraProperties(extraProperties).build();
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            connectorProperties = new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(connectorProperties));
            connectorProperties.putIfAbsent("bigquery.views-enabled", "true");
            connectorProperties.putIfAbsent("bigquery.view-expire-duration", "30m");
            queryRunner.installPlugin((Plugin)new BigQueryPlugin());
            queryRunner.createCatalog("bigquery", "bigquery", connectorProperties);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("bigquery").setSchema(TPCH_SCHEMA).build();
    }

    public static void main(String[] args) throws Exception {
        DistributedQueryRunner queryRunner = BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"), (Map<String, String>)ImmutableMap.of());
        Thread.sleep(10L);
        Logger log = Logger.get(BigQueryQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static class BigQuerySqlExecutor
    implements SqlExecutor {
        private static final Map.Entry<String, String> BIG_QUERY_SQL_EXECUTOR_LABEL = Maps.immutableEntry((Object)"ci-automation-source", (Object)"trino_tests_big_query_sql_executor");
        private final BigQuery bigQuery = BigQuerySqlExecutor.createBigQueryClient();

        public void execute(String sql) {
            this.executeQuery(sql);
        }

        public TableResult executeQuery(String sql) {
            try {
                return this.bigQuery.query(QueryJobConfiguration.of((String)sql), new BigQuery.JobOption[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public void createDataset(String datasetName) {
            DatasetInfo dataset = DatasetInfo.newBuilder((String)datasetName).setLabels((Map)ImmutableMap.copyOf((Iterable)ImmutableSet.of(BIG_QUERY_SQL_EXECUTOR_LABEL))).build();
            this.bigQuery.create(dataset, new BigQuery.DatasetOption[0]);
        }

        public void dropDatasetIfExists(String dataset) {
            this.bigQuery.delete(dataset, new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
        }

        public List<String> getSelfCreatedDatasets() {
            ImmutableList.Builder datasetNames = ImmutableList.builder();
            for (Dataset dataset : this.bigQuery.listDatasets(new BigQuery.DatasetListOption[]{BigQuery.DatasetListOption.labelFilter((String)String.format("labels.%s:%s", BIG_QUERY_SQL_EXECUTOR_LABEL.getKey(), BIG_QUERY_SQL_EXECUTOR_LABEL.getValue()))}).iterateAll()) {
                datasetNames.add((Object)dataset.getDatasetId().getDataset());
            }
            return datasetNames.build();
        }

        public List<String> getTableNames(String dataset) {
            ImmutableList.Builder tableNames = ImmutableList.builder();
            for (Table table : this.bigQuery.listTables(DatasetId.of((String)dataset), new BigQuery.TableListOption[0]).iterateAll()) {
                tableNames.add((Object)table.getTableId().getTable());
            }
            return tableNames.build();
        }

        public BigQuery getBigQuery() {
            return this.bigQuery;
        }

        private static BigQuery createBigQueryClient() {
            try {
                ByteArrayInputStream jsonKey = new ByteArrayInputStream(Base64.getDecoder().decode(BIGQUERY_CREDENTIALS_KEY));
                return (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)jsonKey))).build().getService();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

