/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestBigQueryClientFactory {
    @Test
    public void testConfigurationOnly() {
        String projectId = BigQueryClientFactory.calculateBillingProjectId(Optional.of("pid"), Optional.empty());
        Assertions.assertThat((String)projectId).isEqualTo("pid");
    }

    @Test
    public void testCredentialsOnly() throws Exception {
        String projectId = BigQueryClientFactory.calculateBillingProjectId(Optional.empty(), this.credentials());
        Assertions.assertThat((String)projectId).isEqualTo("presto-bq-credentials-test");
    }

    @Test
    public void testBothConfigurationAndCredentials() throws Exception {
        String projectId = BigQueryClientFactory.calculateBillingProjectId(Optional.of("pid"), this.credentials());
        Assertions.assertThat((String)projectId).isEqualTo("pid");
    }

    private Optional<Credentials> credentials() throws IOException {
        return Optional.of(GoogleCredentials.fromStream((InputStream)this.getClass().getResourceAsStream("/test-account.json")));
    }
}

