/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestBigQueryConnectorTest
extends BaseConnectorTest {
    protected BigQueryQueryRunner.BigQuerySqlExecutor bigQuerySqlExecutor;

    @BeforeClass(alwaysRun=true)
    public void initBigQueryExecutor() {
        this.bigQuerySqlExecutor = new BigQueryQueryRunner.BigQuerySqlExecutor();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_TOPN_PUSHDOWN: 
            case SUPPORTS_RENAME_SCHEMA: 
            case SUPPORTS_RENAME_TABLE: 
            case SUPPORTS_NOT_NULL_CONSTRAINT: 
            case SUPPORTS_CREATE_TABLE_WITH_DATA: 
            case SUPPORTS_DELETE: 
            case SUPPORTS_INSERT: 
            case SUPPORTS_ADD_COLUMN: 
            case SUPPORTS_DROP_COLUMN: 
            case SUPPORTS_RENAME_COLUMN: 
            case SUPPORTS_COMMENT_ON_TABLE: 
            case SUPPORTS_COMMENT_ON_COLUMN: {
                return false;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestTable.randomTableSuffix();
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        this.assertUpdate("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).startsWith((CharSequence)String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
        this.assertQueryFails("CREATE SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' already exists", schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
        this.assertQueryFails("DROP SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' does not exist", schemaName));
        this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expectedParametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "bigint", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expectedParametrizedVarchar);
    }

    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "bigint", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Test(dataProvider="createTableSupportedTypes")
    public void testCreateTableSupportedType(String createType, String expectedType) {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_table_supported_type_" + createType.replaceAll("[^a-zA-Z0-9]", ""), String.format("(col1 %s)", createType));){
            Assert.assertEquals((Object)this.computeScalar("SELECT data_type FROM information_schema.columns WHERE table_name = '" + table.getName() + "' AND column_name = 'col1'"), (Object)expectedType);
        }
    }

    @DataProvider
    public Object[][] createTableSupportedTypes() {
        return new Object[][]{{"boolean", "boolean"}, {"tinyint", "bigint"}, {"smallint", "bigint"}, {"integer", "bigint"}, {"bigint", "bigint"}, {"double", "double"}, {"decimal", "decimal(38,9)"}, {"date", "date"}, {"time with time zone", "time(6)"}, {"timestamp(6)", "timestamp(6)"}, {"timestamp(6) with time zone", "timestamp(6) with time zone"}, {"char", "varchar"}, {"char(65535)", "varchar"}, {"varchar", "varchar"}, {"varchar(65535)", "varchar"}, {"varbinary", "varbinary"}, {"array(bigint)", "array(bigint)"}, {"row(x bigint, y double)", "row(x bigint, y double)"}, {"row(x array(bigint))", "row(x array(bigint))"}};
    }

    @Test(dataProvider="createTableUnsupportedTypes")
    public void testCreateTableUnsupportedType(String createType) {
        String tableName = String.format("test_create_table_unsupported_type_%s_%s", createType.replaceAll("[^a-zA-Z0-9]", ""), TestTable.randomTableSuffix());
        this.assertQueryFails(String.format("CREATE TABLE %s (col1 %s)", tableName, createType), "Unsupported column type: " + createType);
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
    }

    @DataProvider
    public Object[][] createTableUnsupportedTypes() {
        return new Object[][]{{"json"}, {"uuid"}, {"ipaddress"}};
    }

    @Test
    public void testCreateTableWithRowTypeWithoutField() {
        String tableName = "test_row_type_table_" + TestTable.randomTableSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(col1 row(int))", "\\QROW type does not have field names declared: row(integer)\\E");
    }

    @Test
    public void testCreateTableAlreadyExists() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_table_already_exists", "(col1 int)");){
            this.assertQueryFails("CREATE TABLE " + table.getName() + "(col1 int)", "\\Qline 1:1: Table 'bigquery.tpch." + table.getName() + "' already exists\\E");
        }
    }

    @Test
    public void testCreateTableIfNotExists() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_table_if_not_exists", "(col1 int)");){
            this.assertUpdate("CREATE TABLE IF NOT EXISTS " + table.getName() + "(col1 int)");
        }
    }

    @Test
    public void testCreateTableAsSelect() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableAsSelect()).hasStackTraceContaining("This connector does not support creating tables with data");
    }

    @Test
    public void testCreateTableAsSelectWithUnicode() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableAsSelectWithUnicode()).hasStackTraceContaining("This connector does not support creating tables with data");
    }

    @Test
    public void testDropTable() {
        String tableName = "test_drop_table_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col bigint)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testRenameTable() {
        String tableName = "test_rename_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (x int)");
        String renamedTable = "test_rename_new_" + TestTable.randomTableSuffix();
        this.assertQueryFails("ALTER TABLE " + tableName + " RENAME TO " + renamedTable, "This connector does not support renaming tables");
    }

    @Test(dataProvider="testDataMappingSmokeTestDataProvider")
    public void testDataMappingSmokeTest(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        Assertions.assertThatThrownBy(() -> super.testDataMappingSmokeTest(dataMappingTestSetup)).hasMessageContaining("This connector does not support creating tables with data");
    }

    @Test(dataProvider="testCaseSensitiveDataMappingProvider")
    public void testCaseSensitiveDataMapping(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        Assertions.assertThatThrownBy(() -> super.testCaseSensitiveDataMapping(dataMappingTestSetup)).hasMessageContaining("This connector does not support creating tables with data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String tableName = "test.tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key varchar(50), " + (String)nameInSql + " varchar(50))");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        try {
            this.onBigQuery("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
            this.assertQuery("SELECT " + (String)nameInSql + " FROM " + tableName, "VALUES (NULL), ('abc'), ('xyz')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + (String)nameInSql + " IS NULL", "VALUES ('null value')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + (String)nameInSql + " = 'abc'", "VALUES ('sample value')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return Strings.nullToEmpty((String)exception.getMessage()).matches(".*(Fields must contain only letters, numbers, and underscores, start with a letter or underscore, and be at most 300 characters long).*");
    }

    @Test
    public void testSelectFromHourlyPartitionedTable() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.hourly_partitioned", "(value INT64, ts TIMESTAMP) PARTITION BY TIMESTAMP_TRUNC(ts, HOUR)", List.of("1000, '2018-01-01 10:00:00'"));){
            this.assertQuery("SELECT COUNT(1) FROM " + table.getName(), "VALUES 1");
        }
    }

    @Test
    public void testSelectFromYearlyPartitionedTable() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.yearly_partitioned", "(value INT64, ts TIMESTAMP) PARTITION BY TIMESTAMP_TRUNC(ts, YEAR)", List.of("1000, '2018-01-01 10:00:00'"));){
            this.assertQuery("SELECT COUNT(1) FROM " + table.getName(), "VALUES 1");
        }
    }

    @Test(description="regression test for https://github.com/trinodb/trino/issues/7784")
    public void testSelectWithSingleQuoteInWhereClause() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.select_with_single_quote", "(col INT64, val STRING)", List.of("1, 'escape\\'single quote'"));){
            this.assertQuery("SELECT val FROM " + table.getName() + " WHERE val = 'escape''single quote'", "VALUES 'escape''single quote'");
        }
    }

    @Test(description="regression test for https://github.com/trinodb/trino/issues/5618")
    public void testPredicatePushdownPrunnedColumns() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.predicate_pushdown_prunned_columns", "(a INT64, b INT64, c INT64)", List.of("1, 2, 3"));){
            this.assertQuery("SELECT 1 FROM " + table.getName() + " WHERE     ((NULL IS NULL) OR a = 100) AND     b = 2", "VALUES (1)");
        }
    }

    @Test(description="regression test for https://github.com/trinodb/trino/issues/5635")
    public void testCountAggregationView() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.count_aggregation_table", "(a INT64, b INT64, c INT64)", List.of("1, 2, 3", "4, 5, 6"));
             TestView view = new TestView((SqlExecutor)this.bigQuerySqlExecutor, "test.count_aggregation_view", "SELECT * FROM " + table.getName());){
            this.assertQuery("SELECT count(*) FROM " + view.getName(), "VALUES (2)");
            this.assertQuery("SELECT count(*) FROM " + view.getName() + " WHERE a = 1", "VALUES (1)");
            this.assertQuery("SELECT count(a) FROM " + view.getName() + " WHERE b = 2", "VALUES (1)");
        }
    }

    @Test
    public void testRepeatCountAggregationView() {
        try (TestView view = new TestView((SqlExecutor)this.bigQuerySqlExecutor, "test.repeat_count_aggregation_view", "SELECT 1 AS col1");){
            this.assertQuery("SELECT count(*) FROM " + view.getName(), "VALUES (1)");
            this.assertQuery("SELECT count(*) FROM " + view.getName(), "VALUES (1)");
        }
    }

    @Test
    public void testColumnPositionMismatch() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test.test_column_position_mismatch", "(c_varchar VARCHAR, c_int INT, c_date DATE)");){
            this.onBigQuery("INSERT INTO " + table.getName() + " VALUES ('a', 1, '2021-01-01')");
            this.assertQuery("SELECT c_varchar, CAST(c_int AS SMALLINT), c_date FROM " + table.getName(), "VALUES ('a', 1, '2021-01-01')");
        }
    }

    @Test
    public void testViewDefinitionSystemTable() {
        String schemaName = "test";
        String tableName = "views_system_table_base_" + TestTable.randomTableSuffix();
        String viewName = "views_system_table_view_" + TestTable.randomTableSuffix();
        this.onBigQuery(String.format("CREATE TABLE %s.%s (a INT64, b INT64, c INT64)", schemaName, tableName));
        this.onBigQuery(String.format("CREATE VIEW %s.%s AS SELECT * FROM %s.%s", schemaName, viewName, schemaName, tableName));
        Assert.assertEquals((Object)this.computeScalar(String.format("SELECT * FROM %s.\"%s$view_definition\"", schemaName, viewName)), (Object)String.format("SELECT * FROM %s.%s", schemaName, tableName));
        this.assertQueryFails(String.format("SELECT * FROM %s.\"%s$view_definition\"", schemaName, tableName), String.format("Table '%s.%s\\$view_definition' not found", schemaName, tableName));
        this.onBigQuery(String.format("DROP TABLE %s.%s", schemaName, tableName));
        this.onBigQuery(String.format("DROP VIEW %s.%s", schemaName, viewName));
    }

    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).isEqualTo("CREATE TABLE bigquery.tpch.orders (\n   orderkey bigint NOT NULL,\n   custkey bigint NOT NULL,\n   orderstatus varchar NOT NULL,\n   totalprice double NOT NULL,\n   orderdate date NOT NULL,\n   orderpriority varchar NOT NULL,\n   clerk varchar NOT NULL,\n   shippriority bigint NOT NULL,\n   comment varchar NOT NULL\n)");
    }

    @Test
    public void testCharVarcharComparison() {
        Assertions.assertThatThrownBy(() -> super.testCharVarcharComparison()).hasMessage("This connector does not support creating tables with data");
    }

    @Test
    public void testVarcharCharComparison() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.test_varchar_char", "(k int, v string(3))", (List)ImmutableList.of((Object)"-1, NULL", (Object)"0, ''", (Object)"1, ' '", (Object)"2, '  '", (Object)"3, '   '", (Object)"4, 'x'", (Object)"5, 'x '", (Object)"6, 'x  '"));){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (0, ''), (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    @Test
    public void testSkipUnsupportedType() {
        try (TestTable table = new TestTable((SqlExecutor)this.bigQuerySqlExecutor, "test.test_skip_unsupported_type", "(a INT64, unsupported BIGNUMERIC, b INT64)", List.of("1, 999, 2"));){
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 2)");
            Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + table.getName()).getOnlyValue())).isEqualTo("CREATE TABLE bigquery." + table.getName() + " (\n   a bigint,\n   b bigint\n)");
        }
    }

    @Test
    public void testDateYearOfEraPredicate() {
        this.assertQuery("SELECT orderdate FROM orders WHERE orderdate = DATE '1997-09-14'", "VALUES DATE '1997-09-14'");
        Assertions.assertThatThrownBy(() -> this.query("SELECT * FROM orders WHERE orderdate = DATE '-1996-09-14'")).hasMessageMatching(".*Row filter for .* is invalid\\. Filter is '\\(`orderdate` = '-1996-09-14'\\)'");
    }

    @Test
    public void testSymbolAliasing() {
        String tableName = "test.test_symbol_aliasing" + TestTable.randomTableSuffix();
        this.onBigQuery("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4");
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void onBigQuery(String sql) {
        this.bigQuerySqlExecutor.execute(sql);
    }
}

