/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.tpch.TpchTable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestBigQueryInstanceCleaner {
    public static final Logger LOG = Logger.get(TestBigQueryInstanceCleaner.class);
    private static final Collection<String> tablesToKeep = TpchTable.getTables().stream().map(TpchTable::getTableName).map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toUnmodifiableSet());
    public static final Collection<String> tableTypesToDrop = ImmutableList.of((Object)"BASE TABLE", (Object)"VIEW", (Object)"MATERIALIZED VIEW");
    private BigQueryQueryRunner.BigQuerySqlExecutor bigQuerySqlExecutor;

    @BeforeClass
    public void setUp() {
        this.bigQuerySqlExecutor = new BigQueryQueryRunner.BigQuerySqlExecutor();
    }

    @Test
    public void cleanUpDatasets() {
        LOG.info("Identifying datasets to drop...");
        List<String> selfCreatedDatasets = this.bigQuerySqlExecutor.getSelfCreatedDatasets();
        TableResult result = this.bigQuerySqlExecutor.executeQuery(String.format("SELECT schema_name FROM INFORMATION_SCHEMA.SCHEMATA WHERE datetime_diff(current_datetime(), datetime(creation_time), HOUR) > 24 AND schema_name IN (%s)", selfCreatedDatasets.stream().collect(Collectors.joining("','", "'", "'"))));
        List datasetsToDrop = (List)Streams.stream((Iterable)result.getValues()).map(fieldValues -> fieldValues.get("schema_name").getStringValue()).collect(ImmutableList.toImmutableList());
        if (datasetsToDrop.isEmpty()) {
            LOG.info("Did not find any datasets to drop.");
            return;
        }
        LOG.info("Dropping %s datasets.", new Object[]{datasetsToDrop.size()});
        LOG.info("Dropping: %s", new Object[]{datasetsToDrop});
        datasetsToDrop.forEach(dataset -> {
            LOG.info("Dropping dataset '%s' that contains tables: %s", new Object[]{dataset, this.bigQuerySqlExecutor.getTableNames((String)dataset)});
            this.bigQuerySqlExecutor.dropDatasetIfExists((String)dataset);
        });
    }

    @Test(dataProvider="cleanUpSchemasDataProvider")
    public void cleanUpTables(String schemaName) {
        this.logObjectsCount(schemaName);
        if (!tablesToKeep.isEmpty()) {
            LOG.info("Will not drop these tables: %s", new Object[]{String.join((CharSequence)", ", tablesToKeep)});
        }
        LOG.info("Identifying tables to drop...");
        TableResult result = this.bigQuerySqlExecutor.executeQuery(String.format("SELECT table_name, table_type FROM %s.INFORMATION_SCHEMA.TABLES WHERE datetime_diff(current_datetime(), datetime(creation_time), HOUR) > 24 AND table_name NOT IN (%s)AND table_type IN (%s)", TestBigQueryInstanceCleaner.quoted(schemaName), tablesToKeep.stream().collect(Collectors.joining("','", "'", "'")), tableTypesToDrop.stream().collect(Collectors.joining("','", "'", "'"))));
        List objectsToDrop = (List)Streams.stream((Iterable)result.getValues()).map(fieldValues -> new AbstractMap.SimpleImmutableEntry<String, String>(fieldValues.get("table_name").getStringValue(), fieldValues.get("table_type").getStringValue())).collect(ImmutableList.toImmutableList());
        if (objectsToDrop.isEmpty()) {
            LOG.info("Did not find any objects to drop.");
            return;
        }
        LOG.info("Dropping %s objects.", new Object[]{objectsToDrop.size()});
        LOG.info("Dropping: %s", new Object[]{objectsToDrop.stream().map(Map.Entry::getKey).collect(Collectors.joining(", "))});
        objectsToDrop.forEach(entry -> {
            String dropStatement = TestBigQueryInstanceCleaner.getDropStatement(schemaName, (String)entry.getKey(), (String)entry.getValue());
            LOG.info("Executing: %s", new Object[]{dropStatement});
            this.bigQuerySqlExecutor.execute(dropStatement);
        });
        this.logObjectsCount(schemaName);
    }

    @DataProvider
    public static Object[][] cleanUpSchemasDataProvider() {
        return new Object[][]{{"tpch"}, {"test"}};
    }

    private void logObjectsCount(String schemaName) {
        TableResult result = this.bigQuerySqlExecutor.executeQuery(String.format("SELECT table_type, count(*) AS c FROM %s.INFORMATION_SCHEMA.TABLES GROUP BY table_type", TestBigQueryInstanceCleaner.quoted(schemaName)));
        result.getValues().forEach(fieldValues -> LOG.info("Schema '%s' contains '%s' objects of type '%s'", new Object[]{schemaName, fieldValues.get("c").getLongValue(), fieldValues.get("table_type").getStringValue()}));
    }

    private static String getDropStatement(String schemaName, String objectName, String objectType) {
        switch (objectType) {
            case "BASE TABLE": {
                return String.format("DROP TABLE IF EXISTS %s.%s", TestBigQueryInstanceCleaner.quoted(schemaName), TestBigQueryInstanceCleaner.quoted(objectName));
            }
            case "VIEW": {
                return String.format("DROP VIEW IF EXISTS %s.%s", TestBigQueryInstanceCleaner.quoted(schemaName), TestBigQueryInstanceCleaner.quoted(objectName));
            }
            case "MATERIALIZED VIEW": {
                return String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", TestBigQueryInstanceCleaner.quoted(schemaName), TestBigQueryInstanceCleaner.quoted(objectName));
            }
        }
        throw new IllegalArgumentException("Unexpected object type " + objectType);
    }

    private static String quoted(String identifier) {
        return "`" + identifier.replace("\\", "\\\\").replace("`", "\\`") + "`";
    }
}

