/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestBigQueryTypeMapping
extends AbstractTestQueryFramework {
    private BigQueryQueryRunner.BigQuerySqlExecutor bigQuerySqlExecutor;

    @BeforeClass(alwaysRun=true)
    public void initBigQueryExecutor() {
        this.bigQuerySqlExecutor = new BigQueryQueryRunner.BigQuerySqlExecutor();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testBoolean() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "true", (Type)BooleanType.BOOLEAN, "true").addRoundTrip("boolean", "false", (Type)BooleanType.BOOLEAN, "false").addRoundTrip("boolean", "NULL", (Type)BooleanType.BOOLEAN, "CAST(NULL AS BOOLEAN)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.boolean"));
    }

    @Test
    public void testBytes() {
        SqlDataTypeTest.create().addRoundTrip("bytes", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS VARBINARY)").addRoundTrip("bytes", "b''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("bytes", "from_hex('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("bytes", "from_hex('5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD')", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("bytes", "from_hex('4261672066756C6C206F6620F09F92B0')", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("bytes", "from_hex('0001020304050607080DF9367AA7000000')", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("bytes", "from_hex('000000000000')", (Type)VarbinaryType.VARBINARY, "X'000000000000'").addRoundTrip("bytes(10)", "from_hex('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("bytes(4001)", "from_hex('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.bytes"));
    }

    @Test(dataProvider="bigqueryIntegerTypeProvider")
    public void testInteger(String inputType) {
        SqlDataTypeTest.create().addRoundTrip(inputType, "-9223372036854775808", (Type)BigintType.BIGINT, "-9223372036854775808").addRoundTrip(inputType, "9223372036854775807", (Type)BigintType.BIGINT, "9223372036854775807").addRoundTrip(inputType, "0", (Type)BigintType.BIGINT, "CAST(0 AS BIGINT)").addRoundTrip(inputType, "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.integer"));
    }

    @DataProvider
    public Object[][] bigqueryIntegerTypeProvider() {
        return new Object[][]{{"INT64"}, {"INT"}, {"SMALLINT"}, {"SMALLINT"}, {"TINYINT"}, {"BYTEINT"}};
    }

    @Test
    public void testFloat() {
        SqlDataTypeTest.create().addRoundTrip("float64", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS DOUBLE)").addRoundTrip("float64", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("float64", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("float64", "CAST('NaN' AS float64)", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("float64", "CAST('Infinity' AS float64)", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("float64", "CAST('-Infinity' AS float64)", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.float"));
    }

    @Test
    public void testNumericMapping() {
        SqlDataTypeTest.create().addRoundTrip("NUMERIC(3, 0)", "NUMERIC '193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 0)", "NUMERIC '19'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 0)", "NUMERIC '-193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '10.0'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '-10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(4, 2)", "NUMERIC '2'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("NUMERIC(4, 2)", "NUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '2'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '123456789.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 4)", "NUMERIC '12345678901234567890.31'", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("NUMERIC(29, 0)", "NUMERIC '27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("NUMERIC(29, 0)", "NUMERIC '-27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("NUMERIC(30, 5)", "NUMERIC '3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("NUMERIC(30, 5)", "NUMERIC '-3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("NUMERIC(38, 9)", "NUMERIC '100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(38, 9)", "NUMERIC '-100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(10, 3)", "CAST(NULL AS NUMERIC)", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").addRoundTrip("NUMERIC(38, 9)", "CAST(NULL AS NUMERIC)", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.numeric"));
    }

    @Test
    public void testBigNumericMapping() {
        SqlDataTypeTest.create().addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '19'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '-193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 1)", "BIGNUMERIC '10.0'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(3, 1)", "BIGNUMERIC '10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(3, 1)", "BIGNUMERIC '-10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(4, 2)", "BIGNUMERIC '2'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("BIGNUMERIC(4, 2)", "BIGNUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "BIGNUMERIC '2'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "BIGNUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "BIGNUMERIC '123456789.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 4)", "BIGNUMERIC '12345678901234567890.31'", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("BIGNUMERIC(29, 0)", "BIGNUMERIC '27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("BIGNUMERIC(29, 0)", "BIGNUMERIC '-27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("BIGNUMERIC(30, 5)", "BIGNUMERIC '3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("BIGNUMERIC(30, 5)", "BIGNUMERIC '-3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("BIGNUMERIC(38, 9)", "BIGNUMERIC '100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(38, 9)", "BIGNUMERIC '-100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(10, 3)", "CAST(NULL AS BIGNUMERIC)", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").addRoundTrip("BIGNUMERIC(38, 9)", "CAST(NULL AS BIGNUMERIC)", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(1)", "BIGNUMERIC '1'", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(1 AS DECIMAL(1, 0))").addRoundTrip("BIGNUMERIC(1)", "BIGNUMERIC '-1'", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(-1 AS DECIMAL(1, 0))").addRoundTrip("BIGNUMERIC(38)", "BIGNUMERIC '10000000002000000000300000000012345678'", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('10000000002000000000300000000012345678' AS DECIMAL(38, 0))").addRoundTrip("BIGNUMERIC(38)", "BIGNUMERIC '-10000000002000000000300000000012345678'", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-10000000002000000000300000000012345678' AS DECIMAL(38, 0))").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.bignumeric"));
    }

    @Test(dataProvider="bigqueryUnsupportedBigNumericTypeProvider")
    public void testUnsupportedBigNumericMapping(String unsupportedTypeName) {
        try (TestTable table = new TestTable(this.getBigQuerySqlExecutor(), "test.unsupported_bignumeric", String.format("(supported_column INT64, unsupported_column %s)", unsupportedTypeName));){
            this.assertQuery("DESCRIBE " + table.getName(), "VALUES ('supported_column', 'bigint', '', '')");
        }
    }

    @DataProvider
    public Object[][] bigqueryUnsupportedBigNumericTypeProvider() {
        return new Object[][]{{"BIGNUMERIC"}, {"BIGNUMERIC(40,2)"}};
    }

    @Test
    public void testDate() {
        SqlDataTypeTest.create().addRoundTrip("date", "NULL", (Type)DateType.DATE, "CAST(NULL AS DATE)").addRoundTrip("date", "DATE '0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "DATE '0012-12-12'", (Type)DateType.DATE, "DATE '0012-12-12'").addRoundTrip("date", "DATE '1500-01-01'", (Type)DateType.DATE, "DATE '1500-01-01'").addRoundTrip("date", "DATE '1582-10-04'", (Type)DateType.DATE, "DATE '1582-10-04'").addRoundTrip("date", "DATE '1582-10-05'", (Type)DateType.DATE, "DATE '1582-10-05'").addRoundTrip("date", "DATE '1582-10-14'", (Type)DateType.DATE, "DATE '1582-10-14'").addRoundTrip("date", "DATE '1582-10-15'", (Type)DateType.DATE, "DATE '1582-10-15'").addRoundTrip("date", "DATE '1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "DATE '1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'").addRoundTrip("date", "DATE '2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "DATE '2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "DATE '9999-12-31'", (Type)DateType.DATE, "DATE '9999-12-31'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.date"));
    }

    @Test
    public void testDatetime() {
        SqlDataTypeTest.create().addRoundTrip("datetime", "datetime '0001-01-01 00:00:00.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '0001-01-01 00:00:00.000000'").addRoundTrip("datetime", "datetime '1958-01-01 13:18:03.123'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1958-01-01 13:18:03.123000'").addRoundTrip("datetime", "datetime '2019-03-18 10:01:17.987'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2019-03-18 10:01:17.987000'").addRoundTrip("datetime", "datetime '2018-10-28 01:33:17.456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 01:33:17.456000'").addRoundTrip("datetime", "datetime '2018-10-28 03:33:33.333'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 03:33:33.333000'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:00.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.000000'").addRoundTrip("datetime", "datetime '1970-01-01 00:13:42.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:13:42.000000'").addRoundTrip("datetime", "datetime '2018-04-01 02:13:55.123'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-04-01 02:13:55.123000'").addRoundTrip("datetime", "datetime '2018-03-25 03:17:17.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-03-25 03:17:17.000000'").addRoundTrip("datetime", "datetime '1986-01-01 00:13:07.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1986-01-01 00:13:07.000000'").addRoundTrip("datetime", "datetime '1958-01-01 13:18:03.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1958-01-01 13:18:03.123456'").addRoundTrip("datetime", "datetime '2019-03-18 10:01:17.987654'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2019-03-18 10:01:17.987654'").addRoundTrip("datetime", "datetime '2018-10-28 01:33:17.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 01:33:17.123456'").addRoundTrip("datetime", "datetime '2018-10-28 03:33:33.333333'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 03:33:33.333333'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:00.000000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.000000'").addRoundTrip("datetime", "datetime '1970-01-01 00:13:42.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:13:42.123456'").addRoundTrip("datetime", "datetime '2018-04-01 02:13:55.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-04-01 02:13:55.123456'").addRoundTrip("datetime", "datetime '2018-03-25 03:17:17.456789'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-03-25 03:17:17.456789'").addRoundTrip("datetime", "datetime '1986-01-01 00:13:07.456789'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1986-01-01 00:13:07.456789'").addRoundTrip("datetime", "datetime '2021-09-07 23:59:59.999999'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2021-09-07 23:59:59.999999'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.000000'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01.1'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.100000'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01.12'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.120000'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01.123'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123000'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01.1234'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123400'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01.12345'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123450'").addRoundTrip("datetime", "datetime '1970-01-01 00:00:01.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123456'").addRoundTrip("datetime", "datetime '1969-12-31 23:59:59.999995'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.999995'").addRoundTrip("datetime", "datetime '1969-12-31 23:59:59.999949'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.999949'").addRoundTrip("datetime", "datetime '1969-12-31 23:59:59.999994'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.999994'").addRoundTrip("datetime", "datetime '9999-12-31 23:59:59.999999'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '9999-12-31 23:59:59.999999'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.datetime"));
    }

    @Test
    public void testTime() {
        SqlDataTypeTest.create().addRoundTrip("time", "'00:00:00'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.000000'").addRoundTrip("time", "'00:00:00.000000'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.000000'").addRoundTrip("time", "'00:00:00.123456'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.123456'").addRoundTrip("time", "'12:34:56'", (Type)TimeType.createTimeType((int)6), "TIME '12:34:56.000000'").addRoundTrip("time", "'12:34:56.123456'", (Type)TimeType.createTimeType((int)6), "TIME '12:34:56.123456'").addRoundTrip("time", "'23:59:59'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.000000'").addRoundTrip("time", "'23:59:59.9'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.900000'").addRoundTrip("time", "'23:59:59.99'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.990000'").addRoundTrip("time", "'23:59:59.999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999000'").addRoundTrip("time", "'23:59:59.9999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999900'").addRoundTrip("time", "'23:59:59.99999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999990'").addRoundTrip("time", "'23:59:59.999999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999999'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.time"));
    }

    @Test
    public void testTimestampWithTimeZone() {
        SqlDataTypeTest.create().addRoundTrip("TIMESTAMP", "TIMESTAMP '0001-01-01 00:00:00.000000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '0001-01-01 00:00:00.000000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1970-01-01 00:00:00.000000 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1969-12-31 18:30:00.000000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1970-01-01 00:00:00.000000+02:17'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1969-12-31 21:43:00.000000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1970-01-01 00:00:00.000000-07:31'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 07:31:00.000000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1958-01-01 13:18:03.123456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 13:18:03.123456 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1958-01-01 13:18:03.123000 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 07:48:03.123000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1958-01-01 13:18:03.123000+02:17'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 11:01:03.123000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '1958-01-01 13:18:03.123000-07:31'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 20:49:03.123000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '2019-03-18 10:01:17.987654 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2019-03-18 10:01:17.987654 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '2019-03-18 10:01:17.987000 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2019-03-18 04:16:17.987000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '2019-03-18 10:01:17.987000+02:17'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2019-03-18 07:44:17.987000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '2019-03-18 10:01:17.987000-07:31'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2019-03-18 17:32:17.987000 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '2021-09-07 23:59:59.999999-00:00'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2021-09-07 23:59:59.999999 UTC'").addRoundTrip("TIMESTAMP", "TIMESTAMP '9999-12-31 23:59:59.999999-00:00'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '9999-12-31 23:59:59.999999 UTC'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.timestamp_tz"));
    }

    @Test
    public void testString() {
        SqlDataTypeTest.create().addRoundTrip("STRING", "NULL", (Type)VarcharType.VARCHAR, "CAST(NULL AS VARCHAR)").addRoundTrip("STRING", "'text_a'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_a'").addRoundTrip("STRING", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.VARCHAR, "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("STRING", "'\ud83d\ude02'", (Type)VarcharType.VARCHAR, "VARCHAR '\ud83d\ude02'").addRoundTrip("STRING", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.VARCHAR, "VARCHAR '\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'").addRoundTrip("STRING(255)", "'text_b'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_b'").addRoundTrip("STRING(4001)", "'text_c'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_c'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.string"));
    }

    @Test
    public void testGeography() {
        SqlDataTypeTest.create().addRoundTrip("GEOGRAPHY", "ST_GeogPoint(0, 0)", (Type)VarcharType.VARCHAR, "VARCHAR 'POINT(0 0)'").addRoundTrip("GEOGRAPHY", "ST_GeogPoint(90, -90)", (Type)VarcharType.VARCHAR, "VARCHAR 'POINT(90 -90)'").addRoundTrip("GEOGRAPHY", "NULL", (Type)VarcharType.VARCHAR, "CAST(NULL AS VARCHAR)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.geography"));
    }

    @Test
    public void testArray() {
        SqlDataTypeTest.create().addRoundTrip("ARRAY<BOOLEAN>", "[true]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "ARRAY[true]").addRoundTrip("ARRAY<INT64>", "[1]", (Type)new ArrayType((Type)BigintType.BIGINT), "ARRAY[BIGINT '1']").addRoundTrip("ARRAY<STRING>", "['string']", (Type)new ArrayType((Type)VarcharType.VARCHAR), "ARRAY[VARCHAR 'string']").addRoundTrip("ARRAY<STRUCT<x INT64, y STRING>>", "[(1, 'string')]", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)))), "ARRAY[CAST(ROW(1, 'string') AS ROW(x BIGINT, y VARCHAR))]").addRoundTrip("ARRAY<BOOLEAN>", "[]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "CAST(ARRAY[] AS ARRAY<BOOLEAN>)").addRoundTrip("ARRAY<BOOLEAN>", "NULL", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "CAST(ARRAY[] AS ARRAY<BOOLEAN>)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.array"));
    }

    @Test
    public void testStruct() {
        SqlDataTypeTest.create().addRoundTrip("STRUCT<x INT64>", "STRUCT(1)", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT))), "CAST(ROW(1) AS ROW(x BIGINT))").addRoundTrip("STRUCT<x INT64, y STRING>", "(1, 'string')", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR))), "CAST(ROW(1, 'string') AS ROW(x BIGINT, y VARCHAR))").addRoundTrip("STRUCT<x STRUCT<y STRING>>", "STRUCT(STRUCT('nested' AS y) AS x)", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)))))), "CAST(ROW(ROW('nested')) AS ROW(X ROW(Y VARCHAR)))").addRoundTrip("STRUCT<x INT64>", "NULL", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT))), "CAST(NULL AS ROW(x BIGINT))").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.struct"));
    }

    private DataSetup bigqueryCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup(this.getBigQuerySqlExecutor(), tableNamePrefix);
    }

    private SqlExecutor getBigQuerySqlExecutor() {
        return sql -> this.bigQuerySqlExecutor.execute(sql);
    }
}

