/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.bigquery.StaticCredentialsConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStaticCredentialsConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((StaticCredentialsConfig)ConfigAssertions.recordDefaults(StaticCredentialsConfig.class)).setCredentialsKey(null).setCredentialsFile(null));
    }

    @Test
    public void testExplicitPropertyMappingsWithCredentialsKey() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"bigquery.credentials-key", (Object)"key").buildOrThrow();
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        StaticCredentialsConfig config = (StaticCredentialsConfig)configurationFactory.build(StaticCredentialsConfig.class);
        Assert.assertEquals((Object)config.getCredentialsKey(), Optional.of("key"));
        Assert.assertEquals((Object)config.getCredentialsFile(), Optional.empty());
    }

    @Test
    public void testExplicitPropertyMappingsWithCredentialsFile() {
        try {
            Path file = Files.createTempFile("config", ".json", new FileAttribute[0]);
            ImmutableMap properties = ImmutableMap.builder().put((Object)"bigquery.credentials-file", (Object)file.toString()).buildOrThrow();
            ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
            StaticCredentialsConfig config = (StaticCredentialsConfig)configurationFactory.build(StaticCredentialsConfig.class);
            Assert.assertEquals((Object)config.getCredentialsKey(), Optional.empty());
            Assert.assertEquals((Object)config.getCredentialsFile(), Optional.of(file.toString()));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExplicitPropertyMappingsValidation() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"bigquery.credentials-key", (Object)"key").put((Object)"bigquery.credentials-file", (Object)"file").buildOrThrow();
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> configurationFactory.build(StaticCredentialsConfig.class)).isInstanceOf(ConfigurationException.class)).hasMessageContaining("Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified");
    }
}

