/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.plugin.bigquery.Conversions;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTypeConversions {
    @Test
    public void testConvertBooleanField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.BOOLEAN, (Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testConvertBytesField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.BYTES, (Type)VarbinaryType.VARBINARY);
    }

    @Test
    public void testConvertDateField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.DATE, (Type)DateType.DATE);
    }

    @Test
    public void testConvertDateTimeField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.DATETIME, (Type)TimestampType.TIMESTAMP_MICROS);
    }

    @Test
    public void testConvertFloatField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.FLOAT, (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testConvertGeographyField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.GEOGRAPHY, (Type)VarcharType.VARCHAR);
    }

    @Test
    public void testConvertIntegerField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.INTEGER, (Type)BigintType.BIGINT);
    }

    @Test
    public void testConvertNumericField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.NUMERIC, (Type)DecimalType.createDecimalType((int)38, (int)9));
    }

    @Test
    public void testConvertStringField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.STRING, (Type)VarcharType.VARCHAR);
    }

    @Test
    public void testConvertTimeField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.TIME, (Type)TimeType.TIME_MICROS);
    }

    @Test
    public void testConvertTimestampField() {
        TestTypeConversions.assertSimpleFieldTypeConversion(LegacySQLTypeName.TIMESTAMP, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS);
    }

    @Test
    public void testConvertOneLevelRecordField() {
        Field field = Field.of((String)"rec", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.of((String)"sub_s", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)"sub_i", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])});
        ColumnMetadata metadata = Conversions.toColumnMetadata((Field)field);
        RowType targetType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"sub_s", (Type)VarcharType.VARCHAR), RowType.field((String)"sub_i", (Type)BigintType.BIGINT)});
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)targetType);
    }

    @Test
    public void testConvertTwoLevelsRecordField() {
        Field field = Field.of((String)"rec", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.of((String)"sub_rec", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.of((String)"sub_sub_s", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)"sub_sub_i", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])}), Field.of((String)"sub_s", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)"sub_i", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])});
        ColumnMetadata metadata = Conversions.toColumnMetadata((Field)field);
        RowType targetType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"sub_rec", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"sub_sub_s", (Type)VarcharType.VARCHAR), RowType.field((String)"sub_sub_i", (Type)BigintType.BIGINT)})), RowType.field((String)"sub_s", (Type)VarcharType.VARCHAR), RowType.field((String)"sub_i", (Type)BigintType.BIGINT)});
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)targetType);
    }

    @Test
    public void testConvertStringArrayField() {
        Field field = Field.newBuilder((String)"test", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build();
        ColumnMetadata metadata = Conversions.toColumnMetadata((Field)field);
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)new ArrayType((Type)VarcharType.VARCHAR));
    }

    @Test
    public void testConvertBooleanColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.BOOLEAN, (Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testConvertBytesColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.BYTES, (Type)VarbinaryType.VARBINARY);
    }

    @Test
    public void testConvertDateColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.DATE, (Type)DateType.DATE);
    }

    @Test
    public void testConvertDateTimeColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.DATETIME, (Type)TimestampType.TIMESTAMP_MICROS);
    }

    @Test
    public void testConvertFloatColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.FLOAT, (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testConvertGeographyColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.GEOGRAPHY, (Type)VarcharType.VARCHAR);
    }

    @Test
    public void testConvertIntegerColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.INTEGER, (Type)BigintType.BIGINT);
    }

    @Test
    public void testConvertNumericColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.NUMERIC, (Type)DecimalType.createDecimalType((int)38, (int)9));
    }

    @Test
    public void testConvertStringColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.STRING, (Type)VarcharType.VARCHAR);
    }

    @Test
    public void testConvertTimeColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.TIME, (Type)TimeType.TIME_MICROS);
    }

    @Test
    public void testConvertTimestampColumn() {
        TestTypeConversions.assertSimpleColumnTypeConversion(LegacySQLTypeName.TIMESTAMP, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS);
    }

    @Test
    public void testConvertOneLevelRecordColumn() {
        BigQueryColumnHandle column = new BigQueryColumnHandle("rec", BigQueryType.RECORD, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of((Object)new BigQueryColumnHandle("sub_s", BigQueryType.STRING, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null), (Object)new BigQueryColumnHandle("sub_i", BigQueryType.INTEGER, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null)), null);
        ColumnMetadata metadata = column.getColumnMetadata();
        RowType targetType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"sub_s", (Type)VarcharType.VARCHAR), RowType.field((String)"sub_i", (Type)BigintType.BIGINT)});
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)targetType);
    }

    @Test
    public void testConvertTwoLevelsRecordColumn() {
        BigQueryColumnHandle column = new BigQueryColumnHandle("rec", BigQueryType.RECORD, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of((Object)new BigQueryColumnHandle("sub_rec", BigQueryType.RECORD, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of((Object)new BigQueryColumnHandle("sub_sub_s", BigQueryType.STRING, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null), (Object)new BigQueryColumnHandle("sub_sub_i", BigQueryType.INTEGER, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null)), null), (Object)new BigQueryColumnHandle("sub_s", BigQueryType.STRING, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null), (Object)new BigQueryColumnHandle("sub_i", BigQueryType.INTEGER, Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null)), null);
        ColumnMetadata metadata = column.getColumnMetadata();
        RowType targetType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"sub_rec", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"sub_sub_s", (Type)VarcharType.VARCHAR), RowType.field((String)"sub_sub_i", (Type)BigintType.BIGINT)})), RowType.field((String)"sub_s", (Type)VarcharType.VARCHAR), RowType.field((String)"sub_i", (Type)BigintType.BIGINT)});
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)targetType);
    }

    @Test
    public void testConvertStringArrayColumn() {
        BigQueryColumnHandle column = new BigQueryColumnHandle("test", BigQueryType.STRING, Field.Mode.REPEATED, null, null, (List)ImmutableList.of(), null);
        ColumnMetadata metadata = column.getColumnMetadata();
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)new ArrayType((Type)VarcharType.VARCHAR));
    }

    @Test
    public void testBigQueryDateTimeToJavaConversion() {
        Assertions.assertThat((LocalDateTime)BigQueryType.toLocalDateTime((String)"2001-01-01T01:01:01.1")).isEqualTo((Object)LocalDateTime.of(2001, Month.JANUARY, 1, 1, 1, 1, 100000000));
        Assertions.assertThat((LocalDateTime)BigQueryType.toLocalDateTime((String)"2002-02-02T02:02:02.22")).isEqualTo((Object)LocalDateTime.of(2002, Month.FEBRUARY, 2, 2, 2, 2, 220000000));
        Assertions.assertThat((LocalDateTime)BigQueryType.toLocalDateTime((String)"2003-03-03T03:03:03.333")).isEqualTo((Object)LocalDateTime.of(2003, Month.MARCH, 3, 3, 3, 3, 333000000));
        Assertions.assertThat((LocalDateTime)BigQueryType.toLocalDateTime((String)"2004-04-04T04:04:04.4444")).isEqualTo((Object)LocalDateTime.of(2004, Month.APRIL, 4, 4, 4, 4, 444400000));
        Assertions.assertThat((LocalDateTime)BigQueryType.toLocalDateTime((String)"2005-05-05T05:05:05.55555")).isEqualTo((Object)LocalDateTime.of(2005, Month.MAY, 5, 5, 5, 5, 555550000));
        Assertions.assertThat((LocalDateTime)BigQueryType.toLocalDateTime((String)"2006-06-06T06:06:06.666666")).isEqualTo((Object)LocalDateTime.of(2006, Month.JUNE, 6, 6, 6, 6, 666666000));
    }

    private static void assertSimpleFieldTypeConversion(LegacySQLTypeName from, Type to) {
        ColumnMetadata metadata = Conversions.toColumnMetadata((Field)TestTypeConversions.createField(from));
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)to);
    }

    private static Field createField(LegacySQLTypeName type) {
        return Field.of((String)"test", (LegacySQLTypeName)type, (Field[])new Field[0]);
    }

    private static void assertSimpleColumnTypeConversion(LegacySQLTypeName from, Type to) {
        ColumnMetadata metadata = TestTypeConversions.createColumn(from).getColumnMetadata();
        Assertions.assertThat((Object)metadata.getType()).isEqualTo((Object)to);
    }

    private static BigQueryColumnHandle createColumn(LegacySQLTypeName type) {
        return new BigQueryColumnHandle("test", BigQueryType.valueOf((String)type.name()), Field.Mode.NULLABLE, null, null, (List)ImmutableList.of(), null);
    }
}

