/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.common.cache.CacheBuilder;
import io.airlift.units.Duration;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.IdentityCacheMapping;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class BigQueryClientFactory {
    private final IdentityCacheMapping identityCacheMapping;
    private final BigQueryCredentialsSupplier credentialsSupplier;
    private final Optional<String> parentProjectId;
    private final Optional<String> projectId;
    private final boolean caseInsensitiveNameMatching;
    private final ViewMaterializationCache materializationCache;
    private final HeaderProvider headerProvider;
    private final NonEvictableCache<IdentityCacheMapping.IdentityCacheKey, BigQueryClient> clientCache;
    private final Duration metadataCacheTtl;

    @Inject
    public BigQueryClientFactory(IdentityCacheMapping identityCacheMapping, BigQueryCredentialsSupplier credentialsSupplier, BigQueryConfig bigQueryConfig, ViewMaterializationCache materializationCache, HeaderProvider headerProvider) {
        this.identityCacheMapping = Objects.requireNonNull(identityCacheMapping, "identityCacheMapping is null");
        this.credentialsSupplier = Objects.requireNonNull(credentialsSupplier, "credentialsSupplier is null");
        Objects.requireNonNull(bigQueryConfig, "bigQueryConfig is null");
        this.parentProjectId = bigQueryConfig.getParentProjectId();
        this.projectId = bigQueryConfig.getProjectId();
        this.caseInsensitiveNameMatching = bigQueryConfig.isCaseInsensitiveNameMatching();
        this.materializationCache = Objects.requireNonNull(materializationCache, "materializationCache is null");
        this.headerProvider = Objects.requireNonNull(headerProvider, "headerProvider is null");
        this.metadataCacheTtl = bigQueryConfig.getMetadataCacheTtl();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(bigQueryConfig.getServiceCacheTtl().toMillis(), TimeUnit.MILLISECONDS);
        this.clientCache = SafeCaches.buildNonEvictableCache((CacheBuilder)cacheBuilder);
    }

    public BigQueryClient create(ConnectorSession session) {
        IdentityCacheMapping.IdentityCacheKey cacheKey = this.identityCacheMapping.getRemoteUserCacheKey(session);
        return (BigQueryClient)CacheUtils.uncheckedCacheGet(this.clientCache, (Object)cacheKey, () -> this.createBigQueryClient(session));
    }

    protected BigQueryClient createBigQueryClient(ConnectorSession session) {
        return new BigQueryClient(this.createBigQuery(session), this.caseInsensitiveNameMatching, this.materializationCache, this.metadataCacheTtl, this.projectId);
    }

    protected BigQuery createBigQuery(ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        String billingProjectId = BigQueryClientFactory.calculateBillingProjectId(this.parentProjectId, credentials);
        BigQueryOptions.Builder options = (BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setHeaderProvider(this.headerProvider)).setProjectId(billingProjectId);
        credentials.ifPresent(arg_0 -> ((BigQueryOptions.Builder)options).setCredentials(arg_0));
        return (BigQuery)options.build().getService();
    }

    static String calculateBillingProjectId(Optional<String> configParentProjectId, Optional<Credentials> credentials) {
        return configParentProjectId.orElseGet(() -> credentials.filter(ServiceAccountCredentials.class::isInstance).map(ServiceAccountCredentials.class::cast).map(ServiceAccountCredentials::getProjectId).orElseGet(ServiceOptions::getDefaultProjectId));
    }
}

