/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.bigquery.BigQueryPageSinkProvider;
import io.trino.plugin.bigquery.BigQueryPageSourceProvider;
import io.trino.plugin.bigquery.BigQuerySplitManager;
import io.trino.plugin.bigquery.BigQueryTransactionManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class BigQueryConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final BigQueryTransactionManager transactionManager;
    private final BigQuerySplitManager splitManager;
    private final BigQueryPageSourceProvider pageSourceProvider;
    private final BigQueryPageSinkProvider pageSinkProvider;
    private final Set<ConnectorTableFunction> connectorTableFunctions;
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public BigQueryConnector(LifeCycleManager lifeCycleManager, BigQueryTransactionManager transactionManager, BigQuerySplitManager splitManager, BigQueryPageSourceProvider pageSourceProvider, BigQueryPageSinkProvider pageSinkProvider, Set<ConnectorTableFunction> connectorTableFunctions, Set<SessionPropertiesProvider> sessionPropertiesProviders) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.connectorTableFunctions = Objects.requireNonNull(connectorTableFunctions, "connectorTableFunctions is null");
        this.sessionProperties = (List)sessionPropertiesProviders.stream().flatMap(sessionPropertiesProvider -> sessionPropertiesProvider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return this.transactionManager.beginTransaction(isolationLevel, readOnly, autoCommit);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)this.transactionManager.getMetadata(transaction), this.getClass().getClassLoader());
    }

    public void commit(ConnectorTransactionHandle transactionHandle) {
        this.transactionManager.commit(transactionHandle);
    }

    public void rollback(ConnectorTransactionHandle transactionHandle) {
        this.transactionManager.rollback(transactionHandle);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.connectorTableFunctions;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public void shutdown() {
        this.lifeCycleManager.stop();
    }
}

