/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryConnector;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.BigQueryMetadataFactory;
import io.trino.plugin.bigquery.BigQueryPageSinkProvider;
import io.trino.plugin.bigquery.BigQueryPageSourceProvider;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySessionProperties;
import io.trino.plugin.bigquery.BigQuerySplitManager;
import io.trino.plugin.bigquery.BigQueryTransactionManager;
import io.trino.plugin.bigquery.DefaultBigQueryMetadataFactory;
import io.trino.plugin.bigquery.IdentityCacheMapping;
import io.trino.plugin.bigquery.StaticBigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.StaticCredentialsConfig;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.plugin.bigquery.ptf.Query;
import io.trino.spi.NodeManager;
import io.trino.spi.ptf.ConnectorTableFunction;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BigQueryConnectorModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        this.install((Module)new ClientModule());
        this.install((Module)new StaticCredentialsModule());
    }

    public static class ClientModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            binder.bind(BigQueryReadClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryConnector.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryMetadataFactory.class).to(DefaultBigQueryMetadataFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryTransactionManager.class).in(Scopes.SINGLETON);
            binder.bind(BigQuerySplitManager.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryPageSourceProvider.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryPageSinkProvider.class).in(Scopes.SINGLETON);
            binder.bind(ViewMaterializationCache.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(BigQueryConfig.class);
            this.install(ConditionalModule.conditionalModule(BigQueryConfig.class, BigQueryConfig::isArrowSerializationEnabled, ClientModule::verifyPackageAccessAllowed));
            Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(BigQuerySessionProperties.class).in(Scopes.SINGLETON);
        }

        @Provides
        @Singleton
        public static HeaderProvider createHeaderProvider(NodeManager nodeManager) {
            return FixedHeaderProvider.create((String[])new String[]{"user-agent", "Trino/" + nodeManager.getCurrentNode().getVersion()});
        }

        private static void verifyPackageAccessAllowed(Binder binder) {
            Pattern argPattern = Pattern.compile("^--add-opens=(.*)=([A-Za-z0-9_.]+,)*ALL-UNNAMED(,[A-Za-z0-9_.]+)*$");
            Set openedModules = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().map(argPattern::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).collect(Collectors.toSet());
            if (!openedModules.contains("java.base/java.nio")) {
                binder.addError("BigQuery connector requires additional JVM arguments to run when 'bigquery.experimental.arrow-serialization.enabled' is enabled. Please add '--add-opens=java.base/java.nio=ALL-UNNAMED' to the JVM configuration.", new Object[0]);
            }
        }
    }

    public static class StaticCredentialsModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(StaticCredentialsConfig.class);
            OptionalBinder.newOptionalBinder((Binder)binder, IdentityCacheMapping.class).setDefault().to(IdentityCacheMapping.SingletonIdentityCacheMapping.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)binder, BigQueryCredentialsSupplier.class).setDefault().to(StaticBigQueryCredentialsSupplier.class).in(Scopes.SINGLETON);
        }
    }
}

