/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class BigQueryReadClientFactory {
    private final BigQueryCredentialsSupplier credentialsSupplier;
    private final HeaderProvider headerProvider;
    private final ChannelPoolSettings channelPoolSettings;

    @Inject
    public BigQueryReadClientFactory(BigQueryConfig bigQueryConfig, BigQueryCredentialsSupplier bigQueryCredentialsSupplier, HeaderProvider headerProvider) {
        Objects.requireNonNull(bigQueryConfig, "bigQueryConfig is null");
        this.credentialsSupplier = Objects.requireNonNull(bigQueryCredentialsSupplier, "credentialsSupplier is null");
        this.headerProvider = Objects.requireNonNull(headerProvider, "headerProvider is null");
        this.channelPoolSettings = ChannelPoolSettings.builder().setInitialChannelCount(bigQueryConfig.getRpcInitialChannelCount()).setMinChannelCount(bigQueryConfig.getRpcMinChannelCount()).setMaxChannelCount(bigQueryConfig.getRpcMaxChannelCount()).setMinRpcsPerChannel(bigQueryConfig.getMinRpcPerChannel()).setMaxRpcsPerChannel(bigQueryConfig.getMaxRpcPerChannel()).build();
    }

    BigQueryReadClient create(ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        try {
            BigQueryReadSettings.Builder clientSettings = (BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)BigQueryReadSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider(this.headerProvider).setChannelPoolSettings(this.channelPoolSettings).build());
            credentials.ifPresent(value -> clientSettings.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)value)));
            return BigQueryReadClient.create((BigQueryReadSettings)clientSettings.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating BigQueryReadClient", e);
        }
    }
}

