/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.auth.oauth2.GoogleCredentials;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import java.io.IOException;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;

public class StaticCredentialsConfig {
    private Optional<String> credentialsKey = Optional.empty();
    private Optional<String> credentialsFile = Optional.empty();

    @AssertTrue(message="Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified, or the default GoogleCredentials could be created")
    public @AssertTrue(message="Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified, or the default GoogleCredentials could be created") boolean isCredentialsConfigurationValid() {
        if (this.credentialsKey.isPresent() && this.credentialsFile.isPresent()) {
            return false;
        }
        if (this.credentialsKey.isEmpty() && this.credentialsFile.isEmpty()) {
            try {
                GoogleCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public Optional<String> getCredentialsKey() {
        return this.credentialsKey;
    }

    @Config(value="bigquery.credentials-key")
    @ConfigDescription(value="The base64 encoded credentials key")
    @ConfigSecuritySensitive
    public StaticCredentialsConfig setCredentialsKey(String credentialsKey) {
        this.credentialsKey = Optional.ofNullable(credentialsKey);
        return this;
    }

    public Optional<@FileExists String> getCredentialsFile() {
        return this.credentialsFile;
    }

    @Config(value="bigquery.credentials-file")
    @ConfigDescription(value="The path to the JSON credentials file")
    public StaticCredentialsConfig setCredentialsFile(String credentialsFile) {
        this.credentialsFile = Optional.ofNullable(credentialsFile);
        return this;
    }
}

