/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.Conversions;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.AbstractConnectorTableFunction;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.ScalarArgument;
import io.trino.spi.ptf.ScalarArgumentSpecification;
import io.trino.spi.ptf.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;

public class Query
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query";
    private final BigQueryClientFactory clientFactory;

    @Inject
    public Query(BigQueryClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new QueryFunction(this.clientFactory), this.getClass().getClassLoader());
    }

    public static class QueryFunction
    extends AbstractConnectorTableFunction {
        private final BigQueryClientFactory clientFactory;

        public QueryFunction(BigQueryClientFactory clientFactory) {
            super(Query.SCHEMA_NAME, Query.NAME, List.of(ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument argument = (ScalarArgument)Iterables.getOnlyElement(arguments.values());
            String query = ((Slice)argument.getValue()).toStringUtf8();
            BigQueryClient client = this.clientFactory.create(session);
            Schema schema = client.getSchema(query);
            BigQueryQueryRelationHandle queryRelationHandle = new BigQueryQueryRelationHandle(query);
            BigQueryTableHandle tableHandle = new BigQueryTableHandle(queryRelationHandle);
            ImmutableList.Builder columnsBuilder = ImmutableList.builderWithExpectedSize((int)schema.getFields().size());
            for (Field field : schema.getFields()) {
                if (!Conversions.isSupportedType(field)) {
                    throw new UnsupportedOperationException("Unsupported type: " + field.getType());
                }
                columnsBuilder.add((Object)Conversions.toColumnHandle(field));
            }
            Descriptor returnedType = new Descriptor(columnsBuilder.build().stream().map(column -> new Descriptor.Field(column.getName(), Optional.of(column.getTrinoType()))).collect(Collectors.toList()));
            QueryHandle handle = new QueryHandle(tableHandle.withProjectedColumns((List<BigQueryColumnHandle>)columnsBuilder.build()));
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class QueryHandle
    implements ConnectorTableFunctionHandle {
        private final BigQueryTableHandle tableHandle;

        @JsonCreator
        public QueryHandle(@JsonProperty(value="tableHandle") BigQueryTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

