/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.spi.Plugin;
import io.trino.testing.BaseFailureRecoveryTest;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class BaseBigQueryFailureRecoveryTest
extends BaseFailureRecoveryTest {
    public BaseBigQueryFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties) throws Exception {
        return BigQueryQueryRunner.createQueryRunner(configProperties, coordinatorProperties, (Map<String, String>)ImmutableMap.of(), requiredTpchTables, runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", (Map)ImmutableMap.builder().put((Object)"exchange.base-directories", (Object)(System.getProperty("java.io.tmpdir") + "/trino-local-file-system-exchange-manager")).buildOrThrow());
        });
    }

    @Test
    protected boolean areWriteRetriesSupported() {
        return true;
    }

    @Test
    protected void testAnalyzeTable() {
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testDelete() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        String testQuery = "DELETE FROM <table> WHERE orderkey = 1";
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        this.assertThatQuery(testQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).isCoordinatorOnly();
    }

    @Test
    protected void testDeleteWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testMerge() {
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testRefreshMaterializedView() {
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testUpdate() {
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testUpdateWithSubquery() {
        Assumptions.abort((String)"skipped");
    }
}

