/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.plugin.bigquery.BigQueryViewCreateAndInsertDataSetup;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.CreateAndTrinoInsertDataSetup;
import io.trino.testing.datatype.CreateAsSelectDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import io.trino.type.JsonType;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseBigQueryTypeMapping
extends AbstractTestQueryFramework {
    private final BigQueryQueryRunner.BigQuerySqlExecutor bigQuerySqlExecutor = new BigQueryQueryRunner.BigQuerySqlExecutor();
    private final ZoneId jvmZone = ZoneId.systemDefault();
    private final ZoneId vilnius = ZoneId.of("Europe/Vilnius");
    private final ZoneId kathmandu = ZoneId.of("Asia/Kathmandu");

    @Test
    public void testBoolean() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "true", (Type)BooleanType.BOOLEAN, "true").addRoundTrip("boolean", "false", (Type)BooleanType.BOOLEAN, "false").addRoundTrip("boolean", "NULL", (Type)BooleanType.BOOLEAN, "CAST(NULL AS BOOLEAN)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.boolean")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.boolean")).execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.boolean")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.boolean"));
    }

    @Test
    public void testBytes() {
        SqlDataTypeTest.create().addRoundTrip("bytes", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS VARBINARY)").addRoundTrip("bytes", "b''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("bytes", "from_hex('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("bytes", "from_hex('5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD')", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("bytes", "from_hex('4261672066756C6C206F6620F09F92B0')", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("bytes", "from_hex('0001020304050607080DF9367AA7000000')", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("bytes", "from_hex('000000000000')", (Type)VarbinaryType.VARBINARY, "X'000000000000'").addRoundTrip("bytes(10)", "from_hex('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("bytes(4001)", "from_hex('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.bytes")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.bytes"));
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS VARBINARY)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.varbinary")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.varbinary"));
    }

    @Test
    public void testInt64() {
        this.testInt64("BYTEINT");
        this.testInt64("TINYINT");
        this.testInt64("SMALLINT");
        this.testInt64("INTEGER");
        this.testInt64("INT64");
        this.testInt64("INT");
        this.testInt64("BIGINT");
    }

    private void testInt64(String inputType) {
        SqlDataTypeTest.create().addRoundTrip(inputType, "-9223372036854775808", (Type)BigintType.BIGINT, "-9223372036854775808").addRoundTrip(inputType, "9223372036854775807", (Type)BigintType.BIGINT, "9223372036854775807").addRoundTrip(inputType, "0", (Type)BigintType.BIGINT, "CAST(0 AS BIGINT)").addRoundTrip(inputType, "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.integer")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.integer"));
    }

    @Test
    public void testTinyint() {
        SqlDataTypeTest.create().addRoundTrip("tinyint", "-128", (Type)BigintType.BIGINT, "BIGINT '-128'").addRoundTrip("tinyint", "5", (Type)BigintType.BIGINT, "BIGINT '5'").addRoundTrip("tinyint", "127", (Type)BigintType.BIGINT, "BIGINT '127'").addRoundTrip("tinyint", "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.tinyint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.tinyint"));
    }

    @Test
    public void testSmallint() {
        SqlDataTypeTest.create().addRoundTrip("smallint", "-32768", (Type)BigintType.BIGINT, "BIGINT '-32768'").addRoundTrip("smallint", "32456", (Type)BigintType.BIGINT, "BIGINT '32456'").addRoundTrip("smallint", "32767", (Type)BigintType.BIGINT, "BIGINT '32767'").addRoundTrip("smallint", "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.smallint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.smallint"));
    }

    @Test
    public void testInteger() {
        SqlDataTypeTest.create().addRoundTrip("integer", "-2147483648", (Type)BigintType.BIGINT, "BIGINT '-2147483648'").addRoundTrip("integer", "1234567890", (Type)BigintType.BIGINT, "BIGINT '1234567890'").addRoundTrip("integer", "2147483647", (Type)BigintType.BIGINT, "BIGINT '2147483647'").addRoundTrip("integer", "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.integer")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.integer"));
    }

    @Test
    public void testBigint() {
        SqlDataTypeTest.create().addRoundTrip("bigint", "-9223372036854775808", (Type)BigintType.BIGINT, "-9223372036854775808").addRoundTrip("bigint", "9223372036854775807", (Type)BigintType.BIGINT, "9223372036854775807").addRoundTrip("bigint", "0", (Type)BigintType.BIGINT, "CAST(0 AS BIGINT)").addRoundTrip("bigint", "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.bigint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.bigint"));
    }

    @Test
    public void testFloat() {
        SqlDataTypeTest.create().addRoundTrip("float64", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS DOUBLE)").addRoundTrip("float64", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("float64", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("float64", "CAST('NaN' AS float64)", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("float64", "CAST('Infinity' AS float64)", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("float64", "CAST('-Infinity' AS float64)", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.float")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.float"));
    }

    @Test
    public void testDouble() {
        SqlDataTypeTest.create().addRoundTrip("double", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS DOUBLE)").addRoundTrip("double", "double '1.0E100'", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double", "double '123.456E10'", (Type)DoubleType.DOUBLE, "123.456E10").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.double")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.double"));
    }

    @Test
    public void testNumericMapping() {
        SqlDataTypeTest.create().addRoundTrip("NUMERIC(3, 0)", "NUMERIC '193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 0)", "NUMERIC '19'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 0)", "NUMERIC '-193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '10.0'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '-10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(4, 2)", "NUMERIC '2'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("NUMERIC(4, 2)", "NUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '2'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '123456789.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 4)", "NUMERIC '12345678901234567890.31'", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("NUMERIC(29, 0)", "NUMERIC '27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("NUMERIC(29, 0)", "NUMERIC '-27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("NUMERIC(30, 5)", "NUMERIC '3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("NUMERIC(30, 5)", "NUMERIC '-3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("NUMERIC(38, 9)", "NUMERIC '100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(38, 9)", "NUMERIC '-100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(10, 3)", "CAST(NULL AS NUMERIC)", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").addRoundTrip("NUMERIC(38, 9)", "CAST(NULL AS NUMERIC)", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.numeric"));
    }

    @Test
    public void testNumericWriteMapping() {
        SqlDataTypeTest.create().addRoundTrip("NUMERIC(3, 0)", "CAST(193 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 0)", "CAST(19 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 0)", "CAST(-193 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("NUMERIC(3, 1)", "CAST(10.0 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(3, 1)", "CAST(10.1 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(3, 1)", "CAST(-10.1 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("NUMERIC(4, 2)", "CAST(2 AS DECIMAL(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("NUMERIC(4, 2)", "CAST(2.3 AS DECIMAL(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("NUMERIC(24, 2)", "CAST(2 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 2)", "CAST(2.3 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 2)", "CAST(123456789.3 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("NUMERIC(24, 4)", "CAST(12345678901234567890.31 AS DECIMAL(24, 4))", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("NUMERIC(29, 0)", "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("NUMERIC(29, 0)", "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("NUMERIC(30, 5)", "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("NUMERIC(30, 5)", "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("NUMERIC(38, 9)", "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(38, 9)", "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(10, 3)", "CAST(NULL AS DECIMAL(10, 3))", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").addRoundTrip("NUMERIC(38, 9)", "CAST(NULL AS DECIMAL(38, 9))", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").execute(this.getQueryRunner(), this.bigqueryCreateAndTrinoInsert("test.writenumeric"));
    }

    @Test
    public void testNumericMappingView() {
        SqlDataTypeTest.create().addRoundTrip("NUMERIC(3, 0)", "NUMERIC '193'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(193 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(3, 0)", "NUMERIC '19'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(19 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(3, 0)", "NUMERIC '-193'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-193 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '10.0'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(10.0 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '10.1'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(10.1 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(3, 1)", "NUMERIC '-10.1'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-10.1 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(4, 2)", "NUMERIC '2'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(2 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(4, 2)", "NUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(2.3 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '2'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(2 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(2.3 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(24, 2)", "NUMERIC '123456789.3'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(123456789.3 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(24, 4)", "NUMERIC '12345678901234567890.31'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(12345678901234567890.31 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(29, 0)", "NUMERIC '27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST('27182818284590452353602874713' AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(29, 0)", "NUMERIC '-27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST('-27182818284590452353602874713' AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(30, 5)", "NUMERIC '3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(3141592653589793238462643.38327 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(30, 5)", "NUMERIC '-3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-3141592653589793238462643.38327 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(38, 9)", "NUMERIC '100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(38, 9)", "NUMERIC '-100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(10, 3)", "CAST(NULL AS NUMERIC)", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").addRoundTrip("NUMERIC(38, 9)", "CAST(NULL AS NUMERIC)", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.numeric"));
    }

    @Test
    public void testInvalidNumericScaleType() {
        String tableName = "test.invalid_numeric_scale_" + TestingNames.randomNameSuffix();
        try {
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute(String.format("CREATE TABLE %s (invalid_type NUMERIC(38, 10))", tableName))).hasMessageContaining("In NUMERIC(P, S), S must be between 0 and 9");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testBigNumericMapping() {
        SqlDataTypeTest.create().addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '19'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '-193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 1)", "BIGNUMERIC '10.0'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(3, 1)", "BIGNUMERIC '10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(3, 1)", "BIGNUMERIC '-10.1'", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(4, 2)", "BIGNUMERIC '2'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("BIGNUMERIC(4, 2)", "BIGNUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "BIGNUMERIC '2'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "BIGNUMERIC '2.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "BIGNUMERIC '123456789.3'", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 4)", "BIGNUMERIC '12345678901234567890.31'", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("BIGNUMERIC(29, 0)", "BIGNUMERIC '27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("BIGNUMERIC(29, 0)", "BIGNUMERIC '-27182818284590452353602874713'", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("BIGNUMERIC(30, 5)", "BIGNUMERIC '3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("BIGNUMERIC(30, 5)", "BIGNUMERIC '-3141592653589793238462643.38327'", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("BIGNUMERIC(38, 9)", "BIGNUMERIC '100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(38, 9)", "BIGNUMERIC '-100000000020000000001234567.123456789'", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(10, 3)", "CAST(NULL AS BIGNUMERIC)", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").addRoundTrip("BIGNUMERIC(38, 9)", "CAST(NULL AS BIGNUMERIC)", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(1)", "BIGNUMERIC '1'", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(1 AS DECIMAL(1, 0))").addRoundTrip("BIGNUMERIC(1)", "BIGNUMERIC '-1'", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(-1 AS DECIMAL(1, 0))").addRoundTrip("BIGNUMERIC(38)", "BIGNUMERIC '10000000002000000000300000000012345678'", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('10000000002000000000300000000012345678' AS DECIMAL(38, 0))").addRoundTrip("BIGNUMERIC(38)", "BIGNUMERIC '-10000000002000000000300000000012345678'", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-10000000002000000000300000000012345678' AS DECIMAL(38, 0))").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.bignumeric"));
    }

    @Test
    public void testBigNumericWriteMapping() {
        SqlDataTypeTest.create().addRoundTrip("BIGNUMERIC(3, 0)", "CAST(193 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 0)", "CAST(19 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 0)", "CAST(-193 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("BIGNUMERIC(3, 1)", "CAST(10.0 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(3, 1)", "CAST(10.1 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(3, 1)", "CAST(-10.1 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("BIGNUMERIC(4, 2)", "CAST(2 AS DECIMAL(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("BIGNUMERIC(4, 2)", "CAST(2.3 AS DECIMAL(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "CAST(2 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "CAST(2.3 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 2)", "CAST(123456789.3 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("BIGNUMERIC(24, 4)", "CAST(12345678901234567890.31 AS DECIMAL(24, 4))", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("BIGNUMERIC(29, 0)", "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("BIGNUMERIC(29, 0)", "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))", (Type)DecimalType.createDecimalType((int)29, (int)0), "CAST('-27182818284590452353602874713' AS DECIMAL(29, 0))").addRoundTrip("BIGNUMERIC(30, 5)", "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("BIGNUMERIC(30, 5)", "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("BIGNUMERIC(38, 9)", "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(38, 9)", "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(-100000000020000000001234567.123456789 AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(10, 3)", "CAST(NULL AS DECIMAL(10, 3))", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").addRoundTrip("BIGNUMERIC(38, 9)", "CAST(NULL AS DECIMAL(38, 9))", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(NULL AS DECIMAL(38, 9))").addRoundTrip("BIGNUMERIC(1)", "CAST(1 AS DECIMAL(1, 0))", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(1 AS DECIMAL(1, 0))").addRoundTrip("BIGNUMERIC(1)", "CAST(-1 AS DECIMAL(1, 0))", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(-1 AS DECIMAL(1, 0))").execute(this.getQueryRunner(), this.bigqueryCreateAndTrinoInsert("test.writebignumeric"));
    }

    @Test
    public void testUnsupportedBigNumericMappingView() {
        Assertions.assertThatThrownBy(() -> SqlDataTypeTest.create().addRoundTrip("BIGNUMERIC(3, 0)", "BIGNUMERIC '193'", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.bignumeric"))).hasMessageContaining("SELECT * not allowed from relation that has no columns");
    }

    @Test
    public void testUnsupportedBigNumericMapping() {
        this.testUnsupportedBigNumericMapping("BIGNUMERIC");
        this.testUnsupportedBigNumericMapping("BIGNUMERIC(40,2)");
    }

    private void testUnsupportedBigNumericMapping(String unsupportedTypeName) {
        try (TestTable table = new TestTable(this.getBigQuerySqlExecutor(), "test.unsupported_bignumeric", String.format("(supported_column INT64, unsupported_column %s)", unsupportedTypeName));){
            this.assertQuery("DESCRIBE " + table.getName(), "VALUES ('supported_column', 'bigint', '', '')");
        }
    }

    @Test
    public void testDate() {
        SqlDataTypeTest.create().addRoundTrip("date", "NULL", (Type)DateType.DATE, "CAST(NULL AS DATE)").addRoundTrip("date", "DATE '0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "DATE '0012-12-12'", (Type)DateType.DATE, "DATE '0012-12-12'").addRoundTrip("date", "DATE '1500-01-01'", (Type)DateType.DATE, "DATE '1500-01-01'").addRoundTrip("date", "DATE '1582-10-04'", (Type)DateType.DATE, "DATE '1582-10-04'").addRoundTrip("date", "DATE '1582-10-05'", (Type)DateType.DATE, "DATE '1582-10-05'").addRoundTrip("date", "DATE '1582-10-14'", (Type)DateType.DATE, "DATE '1582-10-14'").addRoundTrip("date", "DATE '1582-10-15'", (Type)DateType.DATE, "DATE '1582-10-15'").addRoundTrip("date", "DATE '1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "DATE '1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'").addRoundTrip("date", "DATE '2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "DATE '2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "DATE '9999-12-31'", (Type)DateType.DATE, "DATE '9999-12-31'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.date")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.date")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.date")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.date"));
    }

    @Test
    public void testBigQueryUnsupportedDate() {
        try (TestTable table = new TestTable(this.getBigQuerySqlExecutor(), "test.unsupported_date", "(col date)");){
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES date '-0001-01-01'", "BigQuery supports dates between 0001-01-01 and 9999-12-31 but got -0001-01-01");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES date '0000-12-31'", "BigQuery supports dates between 0001-01-01 and 9999-12-31 but got 0000-12-31");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES date '10000-01-01'", "BigQuery supports dates between 0001-01-01 and 9999-12-31 but got \\+10000-01-01");
        }
    }

    @Test
    public void testTimestamp() {
        this.timestampTypeTest("timestamp(6)", "timestamp").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.timestamp")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.timestamp"));
    }

    @Test
    public void testDatetime() {
        this.timestampTypeTest("datetime", "datetime").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.datetime")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.datetime"));
    }

    private SqlDataTypeTest timestampTypeTest(String inputType, String literalPrefix) {
        return SqlDataTypeTest.create().addRoundTrip(inputType, literalPrefix + " '0001-01-01 00:00:00.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '0001-01-01 00:00:00.000000'").addRoundTrip(inputType, literalPrefix + " '1958-01-01 13:18:03.123'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1958-01-01 13:18:03.123000'").addRoundTrip(inputType, literalPrefix + " '2019-03-18 10:01:17.987'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2019-03-18 10:01:17.987000'").addRoundTrip(inputType, literalPrefix + " '2018-10-28 01:33:17.456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 01:33:17.456000'").addRoundTrip(inputType, literalPrefix + " '2018-10-28 03:33:33.333'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 03:33:33.333000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:00.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.000000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:13:42.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:13:42.000000'").addRoundTrip(inputType, literalPrefix + " '2018-04-01 02:13:55.123'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-04-01 02:13:55.123000'").addRoundTrip(inputType, literalPrefix + " '2018-03-25 03:17:17.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-03-25 03:17:17.000000'").addRoundTrip(inputType, literalPrefix + " '1986-01-01 00:13:07.000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1986-01-01 00:13:07.000000'").addRoundTrip(inputType, literalPrefix + " '1958-01-01 13:18:03.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1958-01-01 13:18:03.123456'").addRoundTrip(inputType, literalPrefix + " '2019-03-18 10:01:17.987654'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2019-03-18 10:01:17.987654'").addRoundTrip(inputType, literalPrefix + " '2018-10-28 01:33:17.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 01:33:17.123456'").addRoundTrip(inputType, literalPrefix + " '2018-10-28 03:33:33.333333'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-10-28 03:33:33.333333'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:00.000000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.000000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:13:42.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:13:42.123456'").addRoundTrip(inputType, literalPrefix + " '2018-04-01 02:13:55.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-04-01 02:13:55.123456'").addRoundTrip(inputType, literalPrefix + " '2018-03-25 03:17:17.456789'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2018-03-25 03:17:17.456789'").addRoundTrip(inputType, literalPrefix + " '1986-01-01 00:13:07.456789'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1986-01-01 00:13:07.456789'").addRoundTrip(inputType, literalPrefix + " '2021-09-07 23:59:59.999999'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2021-09-07 23:59:59.999999'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.000000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01.1'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.100000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01.12'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.120000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01.123'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123000'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01.1234'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123400'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01.12345'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123450'").addRoundTrip(inputType, literalPrefix + " '1970-01-01 00:00:01.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:01.123456'").addRoundTrip(inputType, literalPrefix + " '1969-12-31 23:59:59.999995'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.999995'").addRoundTrip(inputType, literalPrefix + " '1969-12-31 23:59:59.999949'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.999949'").addRoundTrip(inputType, literalPrefix + " '1969-12-31 23:59:59.999994'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.999994'").addRoundTrip(inputType, literalPrefix + " '9999-12-31 23:59:59.999999'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '9999-12-31 23:59:59.999999'");
    }

    @Test
    public void testUnsupportedDatetime() {
        try (TestTable table = new TestTable(this.getBigQuerySqlExecutor(), "test.unsupported_datetime", "(col datetime)");){
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '-0001-01-01 00:00:00.000000')", "Failed to insert rows.*");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '0000-12-31 23:59:59.999999')", "Failed to insert rows.*");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '10000-01-01 00:00:00.000000')", "Failed to insert rows.*");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (datetime '-0001-01-01 00:00:00.000000')")).hasMessageContaining("Invalid DATETIME literal");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (datetime '0000-12-31 23:59:59.999999')")).hasMessageContaining("Invalid DATETIME literal");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (datetime '10000-01-01 00:00:00.000000')")).hasMessageContaining("Invalid DATETIME literal");
        }
    }

    @Test
    public void testTime() {
        SqlDataTypeTest.create().addRoundTrip("time", "'00:00:00'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.000000'").addRoundTrip("time", "'00:00:00.000000'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.000000'").addRoundTrip("time", "'00:00:00.123456'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.123456'").addRoundTrip("time", "'12:34:56'", (Type)TimeType.createTimeType((int)6), "TIME '12:34:56.000000'").addRoundTrip("time", "'12:34:56.123456'", (Type)TimeType.createTimeType((int)6), "TIME '12:34:56.123456'").addRoundTrip("time", "'23:59:59'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.000000'").addRoundTrip("time", "'23:59:59.9'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.900000'").addRoundTrip("time", "'23:59:59.99'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.990000'").addRoundTrip("time", "'23:59:59.999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999000'").addRoundTrip("time", "'23:59:59.9999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999900'").addRoundTrip("time", "'23:59:59.99999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999990'").addRoundTrip("time", "'23:59:59.999999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999999'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.time")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.time"));
    }

    @Test
    public void testTimestampWithTimeZone() {
        this.testTimestampWithTimeZone(ZoneOffset.UTC);
        this.testTimestampWithTimeZone(this.jvmZone);
        this.testTimestampWithTimeZone(this.vilnius);
        this.testTimestampWithTimeZone(this.kathmandu);
        this.testTimestampWithTimeZone(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testTimestampWithTimeZone(ZoneId zoneId) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)zoneId.getId())).build();
        this.testTimestampWithTimeZone("TIMESTAMP(6) WITH TIME ZONE").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.timestamp_tz")).execute(this.getQueryRunner(), this.trinoCreateAsSelect(session, "test.timestamp_tz")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test.timestamp_tz"));
        this.testTimestampWithTimeZone("TIMESTAMP").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.timestamp_tz"));
    }

    private SqlDataTypeTest testTimestampWithTimeZone(String inputType) {
        return SqlDataTypeTest.create().addRoundTrip(inputType, "TIMESTAMP '0001-01-01 00:00:00.000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '0001-01-01 00:00:00.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1958-01-01 13:18:03.123 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 13:18:03.123000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1958-01-01 13:18:03.123456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 13:18:03.123456 UTC'").addRoundTrip(inputType, "TIMESTAMP '1958-01-01 13:18:03.123000 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1958-01-01 07:48:03.123000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1969-12-31 23:59:59.999995 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1969-12-31 23:59:59.999995 UTC'").addRoundTrip(inputType, "TIMESTAMP '1969-12-31 23:59:59.999949 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1969-12-31 23:59:59.999949 UTC'").addRoundTrip(inputType, "TIMESTAMP '1969-12-31 23:59:59.999994 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1969-12-31 23:59:59.999994 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:00.000000 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1969-12-31 18:30:00.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:00.000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01.1 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.100000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01.12 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.120000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01.123 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.123000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01.1234 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.123400 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01.12345 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.123450 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:00:01.123456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:00:01.123456 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:13:42.000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:13:42.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1970-01-01 00:13:42.123456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1970-01-01 00:13:42.123456 UTC'").addRoundTrip(inputType, "TIMESTAMP '1986-01-01 00:13:07.000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1986-01-01 00:13:07.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '1986-01-01 00:13:07.456789 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '1986-01-01 00:13:07.456789 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-03-25 03:17:17.000 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-03-25 03:17:17.000000 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-03-25 03:17:17.456789 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-03-25 03:17:17.456789 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-04-01 02:13:55.123 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-04-01 02:13:55.123000 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-04-01 02:13:55.123456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-04-01 02:13:55.123456 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-10-28 01:33:17.456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-10-28 01:33:17.456000 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-10-28 01:33:17.123456 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-10-28 01:33:17.123456 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-10-28 03:33:33.333 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-10-28 03:33:33.333000 UTC'").addRoundTrip(inputType, "TIMESTAMP '2018-10-28 03:33:33.333333 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2018-10-28 03:33:33.333333 UTC'").addRoundTrip(inputType, "TIMESTAMP '2019-03-18 10:01:17.987 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2019-03-18 10:01:17.987000 UTC'").addRoundTrip(inputType, "TIMESTAMP '2019-03-18 10:01:17.987654 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2019-03-18 10:01:17.987654 UTC'").addRoundTrip(inputType, "TIMESTAMP '2021-09-07 23:59:59.999999 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '2021-09-07 23:59:59.999999 UTC'").addRoundTrip(inputType, "TIMESTAMP '9999-12-31 23:59:59.999999 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, "TIMESTAMP '9999-12-31 23:59:59.999999 UTC'");
    }

    @Test
    public void testUnsupportedTimestampWithTimeZone() {
        try (TestTable table = new TestTable(this.getBigQuerySqlExecutor(), "test.unsupported_tz", "(col timestamp)");){
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '-2021-09-07 23:59:59.999999 UTC')", "Failed to insert rows.*");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '-0001-01-01 00:00:00.000000 UTC')", "Failed to insert rows.*");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '0000-12-31 23:59:59.999999 UTC')", "Failed to insert rows.*");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (timestamp '10000-01-01 00:00:00.000000 UTC')", "Failed to insert rows.*");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (timestamp '-2021-09-07 23:59:59.999999 UTC')")).hasMessageContaining("Invalid TIMESTAMP literal");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (timestamp '-0001-01-01 00:00:00.000000 UTC')")).hasMessageContaining("Invalid TIMESTAMP literal");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (timestamp '0000-12-31 23:59:59.999999 UTC')")).hasMessageContaining("Invalid TIMESTAMP literal");
            Assertions.assertThatThrownBy(() -> this.getBigQuerySqlExecutor().execute("INSERT INTO " + table.getName() + " VALUES (timestamp '10000-01-01 00:00:00.000000 UTC')")).hasMessageContaining("Invalid TIMESTAMP literal");
        }
    }

    @Test
    public void testString() {
        SqlDataTypeTest.create().addRoundTrip("STRING", "NULL", (Type)VarcharType.VARCHAR, "CAST(NULL AS VARCHAR)").addRoundTrip("STRING", "'text_a'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_a'").addRoundTrip("STRING", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.VARCHAR, "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("STRING", "'\ud83d\ude02'", (Type)VarcharType.VARCHAR, "VARCHAR '\ud83d\ude02'").addRoundTrip("STRING", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.VARCHAR, "VARCHAR '\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'").addRoundTrip("STRING(255)", "'text_b'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_b'").addRoundTrip("STRING(4001)", "'text_c'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_c'").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.string")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.string"));
        SqlDataTypeTest.create().addRoundTrip("varchar", "NULL", (Type)VarcharType.VARCHAR, "CAST(NULL AS VARCHAR)").addRoundTrip("varchar", "'text_a'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_a'").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.VARCHAR, "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("varchar", "'\ud83d\ude02'", (Type)VarcharType.VARCHAR, "VARCHAR '\ud83d\ude02'").addRoundTrip("varchar", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.VARCHAR, "VARCHAR '\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'").addRoundTrip("varchar(255)", "'text_b'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_b'").addRoundTrip("varchar(4001)", "'text_c'", (Type)VarcharType.VARCHAR, "VARCHAR 'text_c'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.varchar")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.varchar"));
    }

    @Test
    public void testGeography() {
        SqlDataTypeTest.create().addRoundTrip("GEOGRAPHY", "ST_GeogPoint(0, 0)", (Type)VarcharType.VARCHAR, "VARCHAR 'POINT(0 0)'").addRoundTrip("GEOGRAPHY", "ST_GeogPoint(90, -90)", (Type)VarcharType.VARCHAR, "VARCHAR 'POINT(90 -90)'").addRoundTrip("GEOGRAPHY", "NULL", (Type)VarcharType.VARCHAR, "CAST(NULL AS VARCHAR)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.geography")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.geography"));
    }

    @Test
    public void testJson() {
        SqlDataTypeTest.create().addRoundTrip("JSON", "JSON '{\"name\": \"Alice\", \"age\": 30}'", (Type)JsonType.JSON, "JSON '{\"name\": \"Alice\", \"age\": 30}'").addRoundTrip("JSON", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.json")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.json"));
    }

    @Test
    public void testArray() {
        SqlDataTypeTest.create().addRoundTrip("ARRAY(BOOLEAN)", "ARRAY[true]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "ARRAY[true]").addRoundTrip("ARRAY(INT)", "ARRAY[1]", (Type)new ArrayType((Type)BigintType.BIGINT), "ARRAY[BIGINT '1']").addRoundTrip("ARRAY(VARCHAR)", "ARRAY['string']", (Type)new ArrayType((Type)VarcharType.VARCHAR), "ARRAY[VARCHAR 'string']").addRoundTrip("ARRAY(ROW(x INT, y VARCHAR))", "ARRAY[ROW(1, 'string')]", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)))), "ARRAY[CAST(ROW(1, 'string') AS ROW(x BIGINT, y VARCHAR))]").addRoundTrip("ARRAY(BOOLEAN)", "ARRAY[]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "CAST(ARRAY[] AS ARRAY<BOOLEAN>)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.array")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.array"));
        SqlDataTypeTest.create().addRoundTrip("ARRAY<BOOLEAN>", "[true]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "ARRAY[true]").addRoundTrip("ARRAY<INT64>", "[1]", (Type)new ArrayType((Type)BigintType.BIGINT), "ARRAY[BIGINT '1']").addRoundTrip("ARRAY<STRING>", "['string']", (Type)new ArrayType((Type)VarcharType.VARCHAR), "ARRAY[VARCHAR 'string']").addRoundTrip("ARRAY<STRUCT<x INT64, y STRING>>", "[(1, 'string')]", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)))), "ARRAY[CAST(ROW(1, 'string') AS ROW(x BIGINT, y VARCHAR))]").addRoundTrip("ARRAY<BOOLEAN>", "[]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "CAST(ARRAY[] AS ARRAY<BOOLEAN>)").addRoundTrip("ARRAY<BOOLEAN>", "NULL", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "CAST(ARRAY[] AS ARRAY<BOOLEAN>)").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.array")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.array"));
    }

    @Test
    public void testUnsupportedNullArray() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test.test_null_array", "(col ARRAY(INT))");){
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (NULL)", "NULL value not allowed for NOT NULL column: col");
        }
    }

    @Test
    public void testStruct() {
        SqlDataTypeTest.create().addRoundTrip("ROW(x INT)", "ROW(1)", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT))), "CAST(ROW(1) AS ROW(x BIGINT))").addRoundTrip("ROW(x INT, y VARCHAR)", "(1, 'string')", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR))), "CAST(ROW(1, 'string') AS ROW(x BIGINT, y VARCHAR))").addRoundTrip("ROW(x ROW(y VARCHAR))", "ROW(ROW('nested'))", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)))))), "CAST(ROW(ROW('nested')) AS ROW(X ROW(Y VARCHAR)))").addRoundTrip("ROW(x INT)", "NULL", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT))), "CAST(NULL AS ROW(x BIGINT))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test.row")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test.row"));
        SqlDataTypeTest.create().addRoundTrip("STRUCT<x INT64>", "STRUCT(1)", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT))), "CAST(ROW(1) AS ROW(x BIGINT))").addRoundTrip("STRUCT<x INT64, y STRING>", "(1, 'string')", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR))), "CAST(ROW(1, 'string') AS ROW(x BIGINT, y VARCHAR))").addRoundTrip("STRUCT<x STRUCT<y STRING>>", "STRUCT(STRUCT('nested' AS y) AS x)", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)))))), "CAST(ROW(ROW('nested')) AS ROW(X ROW(Y VARCHAR)))").addRoundTrip("STRUCT<x INT64>", "NULL", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT))), "CAST(NULL AS ROW(x BIGINT))").execute(this.getQueryRunner(), this.bigqueryCreateAndInsert("test.struct")).execute(this.getQueryRunner(), this.bigqueryViewCreateAndInsert("test.struct"));
    }

    private DataSetup trinoCreateAsSelect(String tableNamePrefix) {
        return this.trinoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(String tableNamePrefix) {
        return this.trinoCreateAndInsert(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(Session session, String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup bigqueryCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup(this.getBigQuerySqlExecutor(), tableNamePrefix);
    }

    private DataSetup bigqueryCreateAndTrinoInsert(String tableNamePrefix) {
        return new CreateAndTrinoInsertDataSetup(this.getBigQuerySqlExecutor(), new TrinoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    private DataSetup bigqueryViewCreateAndInsert(String tableNamePrefix) {
        return new BigQueryViewCreateAndInsertDataSetup(this.getBigQuerySqlExecutor(), tableNamePrefix);
    }

    private SqlExecutor getBigQuerySqlExecutor() {
        return sql -> this.bigQuerySqlExecutor.execute(sql);
    }
}

