/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TemporaryRelation;
import java.util.Objects;

public class BigQueryTestView
implements TemporaryRelation {
    private final SqlExecutor sqlExecutor;
    private final TemporaryRelation relation;
    private final String viewName;

    public BigQueryTestView(SqlExecutor sqlExecutor, TemporaryRelation relation) {
        this.sqlExecutor = Objects.requireNonNull(sqlExecutor, "sqlExecutor is null");
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.viewName = relation.getName() + "_view";
        sqlExecutor.execute(String.format("CREATE VIEW %s AS SELECT * FROM %s", this.viewName, relation.getName()));
    }

    public String getName() {
        return this.viewName;
    }

    public void close() {
        try (TemporaryRelation temporaryRelation = this.relation;){
            this.sqlExecutor.execute("DROP VIEW " + this.viewName);
        }
    }
}

