/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.bigquery.BaseBigQueryConnectorTest;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQueryAvroConnectorTest
extends BaseBigQueryConnectorTest {
    private static final Set<String> UNSUPPORTED_COLUMN_NAMES = ImmutableSet.builder().add((Object)"a-hyphen-minus").add((Object)"a space").add((Object)"atrailingspace ").add((Object)" aleadingspace").add((Object)"a:colon").add((Object)"an'apostrophe").add((Object)"0startwithdigit").build();

    protected QueryRunner createQueryRunner() throws Exception {
        return BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"bigquery.job.label-name", (Object)"trino_query", (Object)"bigquery.job.label-format", (Object)"q_$QUERY_ID__t_$TRACE_TOKEN"), REQUIRED_TPCH_TABLES);
    }

    protected Optional<String> filterColumnNameTestData(String columnName) {
        if (UNSUPPORTED_COLUMN_NAMES.contains(columnName)) {
            return Optional.empty();
        }
        return Optional.of(columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectFailsForColumnName() {
        for (String columnName : UNSUPPORTED_COLUMN_NAMES) {
            String tableName = "test.test_unsupported_column_name" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + "(\"" + columnName + "\" varchar(50))");
            try {
                this.assertUpdate("INSERT INTO " + tableName + " VALUES ('test value')", 1L);
                Assertions.assertThatThrownBy(() -> this.query("SELECT * FROM " + tableName)).cause().hasMessageMatching(".*(Illegal initial character|Invalid name).*");
                Assertions.assertThat((Iterable)this.bigQuerySqlExecutor.executeQuery("SELECT * FROM " + tableName).getValues()).extracting(field -> field.get(0).getStringValue()).containsExactly((Object[])new String[]{"test value"});
            }
            finally {
                this.assertUpdate("DROP TABLE " + tableName);
            }
        }
    }
}

