/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestView;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQueryCaseInsensitiveMapping
extends AbstractTestQueryFramework {
    private final BigQueryQueryRunner.BigQuerySqlExecutor bigQuerySqlExecutor = new BigQueryQueryRunner.BigQuerySqlExecutor();

    protected QueryRunner createQueryRunner() throws Exception {
        return BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"bigquery.case-insensitive-name-matching", (Object)"true"), ImmutableList.of());
    }

    @Test
    public void testNonLowerCaseSchemaName() throws Exception {
        String fixedRandom = "a" + TestingNames.randomNameSuffix();
        String bigQuerySchema = fixedRandom + "_NonLowerCaseSchema";
        String trinoSchema = bigQuerySchema.toLowerCase(Locale.ENGLISH);
        try (AutoCloseable ignore1 = this.withSchema(bigQuerySchema);
             AutoCloseable ignore2 = this.withTable(bigQuerySchema + ".lower_case_name", "(c string)");
             AutoCloseable ignore3 = this.withTable(bigQuerySchema + ".Mixed_Case_Name", "(c string)");
             AutoCloseable ignore4 = this.withTable(bigQuerySchema + ".UPPER_CASE_NAME", "(c string)");){
            Assertions.assertThat((Stream)this.computeActual("SHOW SCHEMAS").getOnlyColumn()).contains(new Object[]{trinoSchema});
            this.assertQuery("SHOW SCHEMAS LIKE '" + fixedRandom + "%'", "VALUES '" + trinoSchema + "'");
            this.assertQuery("SHOW TABLES FROM " + trinoSchema, "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT schema_name FROM information_schema.schemata WHERE schema_name LIKE '%" + trinoSchema + "'", "VALUES '" + trinoSchema + "'");
            this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + trinoSchema + "'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + trinoSchema + ".lower_case_name");
        }
    }

    @Test
    public void testNonLowerCaseTableName() throws Exception {
        String bigQuerySchema = "SomeSchema_" + TestingNames.randomNameSuffix();
        String trinoSchema = bigQuerySchema.toLowerCase(Locale.ENGLISH);
        try (AutoCloseable ignore1 = this.withSchema(bigQuerySchema);
             AutoCloseable ignore2 = this.withTable(bigQuerySchema + ".NonLowerCaseTable", "AS SELECT 'a' AS lower_case_name, 'b' AS Mixed_Case_Name, 'c' AS UPPER_CASE_NAME");){
            Assertions.assertThat((Stream)this.computeActual("SHOW TABLES FROM " + trinoSchema).getOnlyColumn()).contains(new Object[]{"nonlowercasetable"});
            Assertions.assertThat((Collection)((Collection)this.computeActual("SHOW COLUMNS FROM " + trinoSchema + ".nonlowercasetable").getMaterializedRows().stream().map(row -> row.getField(0)).collect(ImmutableSet.toImmutableSet()))).isEqualTo((Object)ImmutableSet.of((Object)"lower_case_name", (Object)"mixed_case_name", (Object)"upper_case_name"));
            this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + trinoSchema + "'", "VALUES 'nonlowercasetable'");
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = '" + trinoSchema + "' AND table_name = 'nonlowercasetable'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT lower_case_name FROM " + trinoSchema + ".nonlowercasetable", "VALUES 'a'");
            this.assertQuery("SELECT mixed_case_name FROM " + trinoSchema + ".nonlowercasetable", "VALUES 'b'");
            this.assertQuery("SELECT upper_case_name FROM " + trinoSchema + ".nonlowercasetable", "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM " + bigQuerySchema + ".NonLowerCaseTable", "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM \"" + bigQuerySchema + "\".\"NonLowerCaseTable\"", "VALUES 'c'");
            this.assertUpdate("INSERT INTO " + trinoSchema + ".nonlowercasetable (lower_case_name) VALUES ('l')", 1L);
            this.assertUpdate("INSERT INTO " + trinoSchema + ".nonlowercasetable (mixed_case_name) VALUES ('m')", 1L);
            this.assertUpdate("INSERT INTO " + trinoSchema + ".nonlowercasetable (upper_case_name) VALUES ('u')", 1L);
            this.assertQuery("SELECT * FROM " + trinoSchema + ".nonlowercasetable", "VALUES ('a', 'b', 'c'),('l', NULL, NULL),(NULL, 'm', NULL),(NULL, NULL, 'u')");
            this.assertUpdate("CREATE TABLE " + trinoSchema + ".test_ctas_in_nonlowercase_schema AS SELECT 1 x", 1L);
            this.assertQuery("SELECt * FROM " + trinoSchema + ".test_ctas_in_nonlowercase_schema", "VALUES 1");
        }
    }

    @Test
    public void testNonLowerCaseViewName() throws Exception {
        String bigQuerySchema = "SomeSchema_" + TestingNames.randomNameSuffix();
        String trinoSchema = bigQuerySchema.toLowerCase(Locale.ENGLISH);
        String namePrefix = String.format("%s.Test_Case", bigQuerySchema);
        try (AutoCloseable schema = this.withSchema(bigQuerySchema);
             TestView view = new TestView((SqlExecutor)this.bigQuerySqlExecutor, namePrefix, "SELECT 'a' AS lower_case_name, 'b' AS Mixed_Case_Name, 'c' AS UPPER_CASE_NAME");){
            String viewName = view.getName().substring(bigQuerySchema.length() + 1).toLowerCase(Locale.ENGLISH);
            Assertions.assertThat((Stream)this.computeActual("SHOW TABLES FROM " + trinoSchema).getOnlyColumn()).contains(new Object[]{viewName});
            Assertions.assertThat((Collection)((Collection)this.computeActual("SHOW COLUMNS FROM " + trinoSchema + "." + viewName).getMaterializedRows().stream().map(row -> row.getField(0)).collect(ImmutableSet.toImmutableSet()))).isEqualTo((Object)ImmutableSet.of((Object)"lower_case_name", (Object)"mixed_case_name", (Object)"upper_case_name"));
            this.assertQuery(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", trinoSchema), String.format("VALUES '%s'", viewName));
            this.assertQuery(String.format("SELECT column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", trinoSchema, viewName), "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT lower_case_name FROM " + view.getName(), "VALUES 'a'");
            this.assertQuery("SELECT mixed_case_name FROM " + view.getName(), "VALUES 'b'");
            this.assertQuery("SELECT upper_case_name FROM " + view.getName(), "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM " + view.getName().toLowerCase(Locale.ENGLISH), "VALUES 'c'");
        }
    }

    @Test
    public void testSchemaNameClash() throws Exception {
        String random = "a" + TestingNames.randomNameSuffix();
        String[] nameVariants = new String[]{random + "_casesensitivename", random + "_CaseSensitiveName", random + "_CASESENSITIVENAME"};
        Assertions.assertThat((Collection)((Collection)Stream.of(nameVariants).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                String schemaName = nameVariants[i];
                String otherSchemaName = nameVariants[j];
                try (AutoCloseable ignore1 = this.withSchema(schemaName);
                     AutoCloseable ignore2 = this.withSchema(otherSchemaName);
                     AutoCloseable ignore3 = this.withTable(schemaName + ".some_table_name", "(c string)");){
                    String trinoSchema = schemaName.toLowerCase(Locale.ENGLISH);
                    Assertions.assertThat((Stream)this.computeActual("SHOW SCHEMAS").getOnlyColumn()).doesNotContain(new Object[]{trinoSchema});
                    this.assertQueryReturnsEmptyResult("SHOW SCHEMAS LIKE '" + trinoSchema + "%'");
                    this.assertQueryReturnsEmptyResult("SELECT schema_name FROM information_schema.schemata WHERE schema_name LIKE '%" + trinoSchema + "'");
                    this.assertQueryReturnsEmptyResult("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + trinoSchema + "'");
                    this.assertQueryFails("SHOW CREATE SCHEMA " + trinoSchema, "Found ambiguous names in BigQuery.*");
                    this.assertQueryFails("SHOW TABLES FROM " + trinoSchema, "Found ambiguous names in BigQuery.*");
                    this.assertQueryFails("SELECT * FROM " + trinoSchema + ".some_table_name", "Found ambiguous names in BigQuery.*");
                    continue;
                }
            }
        }
    }

    @Test
    public void testTableNameClash() throws Exception {
        String schema = ("a" + TestingNames.randomNameSuffix() + "_tpch").toLowerCase(Locale.ENGLISH);
        String[] nameVariants = new String[]{"casesensitivename", "CaseSensitiveName", "CASESENSITIVENAME"};
        Assertions.assertThat((Collection)((Collection)Stream.of(nameVariants).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                try (AutoCloseable ignore1 = this.withSchema(schema);
                     AutoCloseable ignore2 = this.withTable(schema + "." + nameVariants[i], "(c string)");
                     AutoCloseable ignore3 = this.withTable(schema + "." + nameVariants[j], "(d string)");){
                    Assertions.assertThat((Stream)this.computeActual("SHOW TABLES FROM " + schema).getOnlyColumn()).doesNotContain(new Object[]{"casesensitivename"});
                    this.assertQueryReturnsEmptyResult("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "'");
                    this.assertQueryReturnsEmptyResult("SELECT column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'casesensitivename'");
                    this.assertQueryFails("SHOW CREATE TABLE " + schema + ".casesensitivename", "Found ambiguous names in BigQuery.*");
                    this.assertQueryFails("SHOW COLUMNS FROM " + schema + ".casesensitivename", "Found ambiguous names in BigQuery.*");
                    this.assertQueryFails("SELECT * FROM " + schema + ".casesensitivename", "Found ambiguous names in BigQuery.*");
                    continue;
                }
            }
        }
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "Test_Create_Case_Sensitive_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName.toLowerCase(Locale.ENGLISH));
        this.assertQuery(String.format("SELECT schema_name FROM information_schema.schemata WHERE schema_name = '%s'", schemaName.toLowerCase(Locale.ENGLISH)), String.format("VALUES '%s'", schemaName.toLowerCase(Locale.ENGLISH)));
        this.assertUpdate("DROP SCHEMA " + schemaName.toLowerCase(Locale.ENGLISH));
    }

    @Test
    public void testCreateSchemaNameClash() throws Exception {
        String schemaName = "Test_Create_Case_Sensitive_Clash_" + TestingNames.randomNameSuffix();
        try (AutoCloseable schema = this.withSchema(schemaName);){
            this.assertQueryFails("CREATE SCHEMA " + schemaName.toLowerCase(Locale.ENGLISH), ".*Schema 'bigquery\\.\\Q" + schemaName.toLowerCase(Locale.ENGLISH) + "\\E' already exists");
        }
    }

    @Test
    public void testDropSchema() throws Exception {
        String schemaName = "Test_Drop_Case_Sensitive_" + TestingNames.randomNameSuffix();
        try (AutoCloseable schema = this.withSchema(schemaName);){
            this.assertUpdate("DROP SCHEMA " + schemaName.toLowerCase(Locale.ENGLISH));
        }
    }

    @Test
    public void testDropSchemaNameClash() throws Exception {
        String schemaName = "Test_Drop_Case_Sensitive_Clash_" + TestingNames.randomNameSuffix();
        try (AutoCloseable schema = this.withSchema(schemaName);
             AutoCloseable secondSchema = this.withSchema(schemaName.toLowerCase(Locale.ENGLISH));){
            this.assertQueryFails("DROP SCHEMA " + schemaName.toLowerCase(Locale.ENGLISH), "Found ambiguous names in BigQuery.*");
        }
    }

    private AutoCloseable withSchema(String schemaName) {
        this.bigQuerySqlExecutor.dropDatasetIfExists(schemaName);
        this.bigQuerySqlExecutor.createDataset(schemaName);
        return () -> this.bigQuerySqlExecutor.dropDatasetIfExists(schemaName);
    }

    @Deprecated
    private AutoCloseable withTable(String tableName, String tableDefinition) {
        this.bigQuerySqlExecutor.execute(String.format("CREATE TABLE %s %s", tableName, tableDefinition));
        return () -> this.bigQuerySqlExecutor.execute(String.format("DROP TABLE %s", tableName));
    }
}

