/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQueryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((BigQueryConfig)ConfigAssertions.recordDefaults(BigQueryConfig.class)).setProjectId(null).setParentProjectId(null).setParallelism(null).setViewExpireDuration(new Duration(24.0, TimeUnit.HOURS)).setSkipViewMaterialization(false).setViewMaterializationProject(null).setViewMaterializationDataset(null).setMaxReadRowsRetries(3).setCaseInsensitiveNameMatching(false).setViewsCacheTtl(new Duration(15.0, TimeUnit.MINUTES)).setServiceCacheTtl(new Duration(3.0, TimeUnit.MINUTES)).setMetadataCacheTtl(new Duration(0.0, TimeUnit.MILLISECONDS)).setViewsEnabled(false).setArrowSerializationEnabled(false).setQueryResultsCacheEnabled(false).setQueryLabelName(null).setQueryLabelFormat(null).setProxyEnabled(false).setMetadataParallelism(2));
    }

    @Test
    public void testExplicitPropertyMappingsWithCredentialsKey() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"bigquery.project-id", (Object)"pid").put((Object)"bigquery.parent-project-id", (Object)"ppid").put((Object)"bigquery.parallelism", (Object)"20").put((Object)"bigquery.views-enabled", (Object)"true").put((Object)"bigquery.experimental.arrow-serialization.enabled", (Object)"true").put((Object)"bigquery.view-expire-duration", (Object)"30m").put((Object)"bigquery.skip-view-materialization", (Object)"true").put((Object)"bigquery.view-materialization-project", (Object)"vmproject").put((Object)"bigquery.view-materialization-dataset", (Object)"vmdataset").put((Object)"bigquery.max-read-rows-retries", (Object)"10").put((Object)"bigquery.case-insensitive-name-matching", (Object)"true").put((Object)"bigquery.views-cache-ttl", (Object)"1m").put((Object)"bigquery.service-cache-ttl", (Object)"10d").put((Object)"bigquery.metadata.cache-ttl", (Object)"5d").put((Object)"bigquery.query-results-cache.enabled", (Object)"true").put((Object)"bigquery.job.label-name", (Object)"trino_job_name").put((Object)"bigquery.job.label-format", (Object)"$TRACE_TOKEN").put((Object)"bigquery.rpc-proxy.enabled", (Object)"true").put((Object)"bigquery.metadata.parallelism", (Object)"31").buildOrThrow();
        BigQueryConfig expected = new BigQueryConfig().setProjectId("pid").setParentProjectId("ppid").setParallelism(Integer.valueOf(20)).setViewsEnabled(true).setArrowSerializationEnabled(true).setViewExpireDuration(new Duration(30.0, TimeUnit.MINUTES)).setSkipViewMaterialization(true).setViewMaterializationProject("vmproject").setViewMaterializationDataset("vmdataset").setMaxReadRowsRetries(10).setCaseInsensitiveNameMatching(true).setViewsCacheTtl(new Duration(1.0, TimeUnit.MINUTES)).setServiceCacheTtl(new Duration(10.0, TimeUnit.DAYS)).setMetadataCacheTtl(new Duration(5.0, TimeUnit.DAYS)).setQueryResultsCacheEnabled(true).setQueryLabelName("trino_job_name").setQueryLabelFormat("$TRACE_TOKEN").setProxyEnabled(true).setMetadataParallelism(31);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testInvalidViewSetting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BigQueryConfig().setViewExpireDuration(new Duration(5.0, TimeUnit.MINUTES)).setViewsCacheTtl(new Duration(10.0, TimeUnit.MINUTES)).validate()).isInstanceOf(IllegalStateException.class)).hasMessage("View expiration duration must be longer than view cache TTL");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BigQueryConfig().setSkipViewMaterialization(true).setViewsEnabled(false).validate()).isInstanceOf(IllegalStateException.class)).hasMessage("bigquery.views-enabled config property must be enabled when skipping view materialization");
    }
}

