/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQueryMetadataCaching
extends AbstractTestQueryFramework {
    protected BigQueryQueryRunner.BigQuerySqlExecutor bigQuerySqlExecutor;

    protected QueryRunner createQueryRunner() throws Exception {
        this.bigQuerySqlExecutor = new BigQueryQueryRunner.BigQuerySqlExecutor();
        return BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"bigquery.metadata.cache-ttl", (Object)"5m"), ImmutableList.of());
    }

    @Test
    public void testMetadataCaching() {
        String schema = "test_metadata_caching_" + TestingNames.randomNameSuffix();
        try {
            this.getQueryRunner().execute("CREATE SCHEMA " + schema);
            Assertions.assertThat((Object)this.getQueryRunner().execute("SHOW SCHEMAS IN bigquery LIKE '" + schema + "'").getOnlyValue()).isEqualTo((Object)schema);
            String schemaTableName = schema + ".test_metadata_caching";
            this.getQueryRunner().execute("CREATE TABLE " + schemaTableName + " AS SELECT * FROM tpch.tiny.region");
            Assertions.assertThat((int)this.getQueryRunner().execute("SELECT * FROM " + schemaTableName).getRowCount()).isEqualTo(5);
            this.bigQuerySqlExecutor.execute("DROP SCHEMA " + schema + " CASCADE");
            Assertions.assertThat((Object)this.getQueryRunner().execute("SHOW SCHEMAS IN bigquery LIKE '" + schema + "'").getOnlyValue()).isEqualTo((Object)schema);
            this.assertQueryFails("SELECT * FROM " + schemaTableName, ".*Schema '.+' does not exist.*");
        }
        finally {
            this.bigQuerySqlExecutor.execute("DROP SCHEMA IF EXISTS " + schema + " CASCADE");
        }
    }
}

