/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.bigquery.BigQueryProxyConfig;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQueryProxyConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((BigQueryProxyConfig)ConfigAssertions.recordDefaults(BigQueryProxyConfig.class)).setUri(null).setPassword(null).setUsername(null).setKeystorePath(null).setKeystorePassword(null).setTruststorePath(null).setTruststorePassword(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path keystoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path truststoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"bigquery.rpc-proxy.uri", (Object)"http://localhost:8000").put((Object)"bigquery.rpc-proxy.username", (Object)"username").put((Object)"bigquery.rpc-proxy.password", (Object)"password").put((Object)"bigquery.rpc-proxy.truststore-path", (Object)truststoreFile.toString()).put((Object)"bigquery.rpc-proxy.truststore-password", (Object)"password-truststore").put((Object)"bigquery.rpc-proxy.keystore-path", (Object)keystoreFile.toString()).put((Object)"bigquery.rpc-proxy.keystore-password", (Object)"password-keystore").buildOrThrow();
        BigQueryProxyConfig expected = new BigQueryProxyConfig().setUri(URI.create("http://localhost:8000")).setUsername("username").setPassword("password").setKeystorePath(keystoreFile.toFile()).setKeystorePassword("password-keystore").setTruststorePath(truststoreFile.toFile()).setTruststorePassword("password-truststore");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testInvalidConfiguration() {
        BigQueryProxyConfig config = new BigQueryProxyConfig();
        config.setUri(URI.create("http://localhost:8000/path"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((BigQueryProxyConfig)config).validate()).isInstanceOf(ConfigurationException.class)).hasMessageContaining("BigQuery RPC proxy URI cannot specify path");
        config.setUri(URI.create("http://localhost:8000"));
        config.setUsername("username");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((BigQueryProxyConfig)config).validate()).isInstanceOf(ConfigurationException.class)).hasMessageContaining("bigquery.rpc-proxy.username was set but bigquery.rpc-proxy.password is empty");
        config.setUsername(null);
        config.setPassword("password");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((BigQueryProxyConfig)config).validate()).isInstanceOf(ConfigurationException.class)).hasMessageContaining("bigquery.rpc-proxy.password was set but bigquery.rpc-proxy.username is empty");
        config.setUsername("username");
        config.validate();
    }
}

