/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryRpcConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestBigQueryRpcConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((BigQueryRpcConfig)ConfigAssertions.recordDefaults(BigQueryRpcConfig.class)).setRpcInitialChannelCount(1).setMinRpcPerChannel(0).setMaxRpcPerChannel(Integer.MAX_VALUE).setRpcMinChannelCount(1).setRpcMaxChannelCount(1).setRetries(0).setTimeout(Duration.valueOf((String)"0s")).setRetryDelay(Duration.valueOf((String)"0s")).setRetryMultiplier(1.0));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"bigquery.channel-pool.initial-size", (Object)"11").put((Object)"bigquery.channel-pool.min-size", (Object)"12").put((Object)"bigquery.channel-pool.max-size", (Object)"13").put((Object)"bigquery.channel-pool.min-rpc-per-channel", (Object)"14").put((Object)"bigquery.channel-pool.max-rpc-per-channel", (Object)"15").put((Object)"bigquery.rpc-retries", (Object)"5").put((Object)"bigquery.rpc-timeout", (Object)"17s").put((Object)"bigquery.rpc-retry-delay", (Object)"10s").put((Object)"bigquery.rpc-retry-delay-multiplier", (Object)"1.2").buildOrThrow();
        BigQueryRpcConfig expected = new BigQueryRpcConfig().setRpcInitialChannelCount(11).setRpcMinChannelCount(12).setRpcMaxChannelCount(13).setMinRpcPerChannel(14).setMaxRpcPerChannel(15).setRetries(5).setTimeout(Duration.valueOf((String)"17s")).setRetryDelay(Duration.valueOf((String)"10s")).setRetryMultiplier(1.2);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

