/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.bigquery.BaseBigQueryConnectorSmokeTest;
import io.trino.plugin.bigquery.BigQueryQueryRunner;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQueryWithDifferentProjectIdConnectorSmokeTest
extends BaseBigQueryConnectorSmokeTest {
    private static final String ALTERNATE_PROJECT_CATALOG = "bigquery";
    private static final String SERVICE_ACCOUNT_CATALOG = "service_account_bigquery";
    protected String alternateProjectId;

    protected QueryRunner createQueryRunner() throws Exception {
        this.alternateProjectId = Objects.requireNonNull(System.getProperty("testing.alternate-bq-project-id"), "testing.alternate-bq-project-id system property not set");
        DistributedQueryRunner queryRunner = BigQueryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"bigquery.project-id", (Object)this.alternateProjectId), REQUIRED_TPCH_TABLES);
        queryRunner.createCatalog(SERVICE_ACCOUNT_CATALOG, ALTERNATE_PROJECT_CATALOG, Map.of());
        return queryRunner;
    }

    @Test
    public void testCreateSchemasInDifferentProjectIdCatalog() {
        String serviceAccountSchema = "service_account_schema" + TestingNames.randomNameSuffix();
        String projectIdSchema = "project_id_schema" + TestingNames.randomNameSuffix();
        try {
            Assertions.assertThat((Collection)this.computeActual("SHOW CATALOGS").getOnlyColumnAsSet()).contains(new Object[]{ALTERNATE_PROJECT_CATALOG, SERVICE_ACCOUNT_CATALOG});
            this.assertUpdate("CREATE SCHEMA service_account_bigquery." + serviceAccountSchema);
            this.assertQuery("SHOW SCHEMAS FROM service_account_bigquery LIKE '" + serviceAccountSchema + "'", "VALUES '" + serviceAccountSchema + "'");
            this.assertUpdate("CREATE SCHEMA bigquery." + projectIdSchema);
            this.assertQuery("SHOW SCHEMAS FROM bigquery LIKE '" + projectIdSchema + "'", "VALUES '" + projectIdSchema + "'");
        }
        finally {
            this.assertUpdate("DROP SCHEMA IF EXISTS service_account_bigquery." + serviceAccountSchema);
            this.assertUpdate("DROP SCHEMA IF EXISTS bigquery." + projectIdSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNativeQuerySelectFromTestTable() {
        String suffix = TestingNames.randomNameSuffix();
        String tableName = "bigquery.test.test_select" + suffix;
        String bigQueryTableName = "`" + this.alternateProjectId + "`.test.test_select" + suffix;
        try {
            this.assertUpdate("CREATE TABLE " + tableName + " (col BIGINT)");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1), (2)", 2L);
            this.assertQuery("SELECT * FROM TABLE(bigquery.system.query(query => 'SELECT * FROM " + bigQueryTableName + "'))", "VALUES 1, 2");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }
}

