/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.collect.ImmutableList;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.trino.plugin.bigquery.MockResponsesBatch;
import io.trino.plugin.bigquery.ReadRowsHelper;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestReadRowsHelper {
    @Test
    public void testNoFailures() {
        BigQueryReadClient client = (BigQueryReadClient)Mockito.mock(BigQueryReadClient.class);
        MockResponsesBatch batch1 = new MockResponsesBatch();
        batch1.addResponse(ReadRowsResponse.newBuilder().setRowCount(10L).build());
        batch1.addResponse(ReadRowsResponse.newBuilder().setRowCount(11L).build());
        ImmutableList responses = ImmutableList.copyOf((Iterator)new MockReadRowsHelper(client, "test", 3, (Iterable<MockResponsesBatch>)ImmutableList.of((Object)batch1)).readRows());
        Assertions.assertThat((int)responses.size()).isEqualTo(2);
        Assertions.assertThat((long)responses.stream().mapToLong(ReadRowsResponse::getRowCount).sum()).isEqualTo(21L);
    }

    @Test
    public void testRetryOfSingleFailure() {
        BigQueryReadClient client = (BigQueryReadClient)Mockito.mock(BigQueryReadClient.class);
        MockResponsesBatch batch1 = new MockResponsesBatch();
        batch1.addResponse(ReadRowsResponse.newBuilder().setRowCount(10L).build());
        batch1.addException((RuntimeException)new StatusRuntimeException(Status.INTERNAL.withDescription("Received unexpected EOS on DATA frame from server.")));
        MockResponsesBatch batch2 = new MockResponsesBatch();
        batch2.addResponse(ReadRowsResponse.newBuilder().setRowCount(11L).build());
        ImmutableList responses = ImmutableList.copyOf((Iterator)new MockReadRowsHelper(client, "test", 3, (Iterable<MockResponsesBatch>)ImmutableList.of((Object)batch1, (Object)batch2)).readRows());
        Assertions.assertThat((int)responses.size()).isEqualTo(2);
        Assertions.assertThat((long)responses.stream().mapToLong(ReadRowsResponse::getRowCount).sum()).isEqualTo(21L);
    }

    private static final class MockReadRowsHelper
    extends ReadRowsHelper {
        Iterator<MockResponsesBatch> responses;

        MockReadRowsHelper(BigQueryReadClient client, String stream, int maxReadRowsRetries, Iterable<MockResponsesBatch> responses) {
            super(client, stream, maxReadRowsRetries);
            this.responses = responses.iterator();
        }

        protected Iterator<ReadRowsResponse> fetchResponses(long offset) {
            return this.responses.next();
        }
    }
}

