/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.AlignedTablePrinter;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAlignedTablePrinter {
    @Test
    public void testAlignedPrinting() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestAlignedTablePrinter.column("first", "varchar")).add((Object)TestAlignedTablePrinter.column("last", "varchar")).add((Object)TestAlignedTablePrinter.column("quantity", "bigint")).build();
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5), TestAlignedTablePrinter.row("b", null, null), TestAlignedTablePrinter.row("some long\ntext that\ndoes not\nfit on\none line", "more\ntext", 4567), TestAlignedTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = "   first   | last  | quantity \n-----------+-------+----------\n hello     | world |      123 \n a         | NULL  |      4.5 \n b         | NULL  |     NULL \n some long+| more +|     4567 \n text that+| text  |          \n does not +|       |          \n fit on   +|       |          \n one line  |       |          \n bye       | done  |      -15 \n(5 rows)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testHexPrintingInLists() throws Exception {
        ImmutableList columns = ImmutableList.of((Object)TestAlignedTablePrinter.column("list", "array"));
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        byte[] value = "hello".getBytes(StandardCharsets.UTF_8);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row(ImmutableList.of((Object)value))), true);
        printer.finish();
        String expected = "       list       \n------------------\n [68 65 6c 6c 6f] \n(1 row)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testHexPrintingInMaps() throws Exception {
        ImmutableList columns = ImmutableList.of((Object)TestAlignedTablePrinter.column("map", "map"));
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        byte[] value = "hello".getBytes(StandardCharsets.UTF_8);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row(TestAlignedTablePrinter.map(TestAlignedTablePrinter.item("key", value), TestAlignedTablePrinter.item("key2", value)))), true);
        printer.finish();
        String expected = "                    map                    \n-------------------------------------------\n {key2=68 65 6c 6c 6f, key=68 65 6c 6c 6f} \n(1 row)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testHexPrintingInMapKeys() throws Exception {
        ImmutableList columns = ImmutableList.of((Object)TestAlignedTablePrinter.column("map", "map"));
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        byte[] value = "hello".getBytes(StandardCharsets.UTF_8);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row(TestAlignedTablePrinter.map(TestAlignedTablePrinter.item(value, "world")))), true);
        printer.finish();
        String expected = "          map           \n------------------------\n {68 65 6c 6c 6f=world} \n(1 row)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testHexPrintingInNestedStructures() throws Exception {
        ImmutableList columns = ImmutableList.of((Object)TestAlignedTablePrinter.column("map", "map"));
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        byte[] value = "hello".getBytes(StandardCharsets.UTF_8);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row(TestAlignedTablePrinter.map(TestAlignedTablePrinter.item("key", Arrays.asList(value, null)), TestAlignedTablePrinter.item("key2", TestAlignedTablePrinter.map(TestAlignedTablePrinter.item("nested", value)))))), true);
        printer.finish();
        String expected = "                            map                             \n------------------------------------------------------------\n {key2={nested=68 65 6c 6c 6f}, key=[68 65 6c 6c 6f, NULL]} \n(1 row)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testAlignedPrintingOneRow() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestAlignedTablePrinter.column("first", "varchar")).add((Object)TestAlignedTablePrinter.column("last", "varchar")).build();
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("a long line\nwithout wrapping", "text")), true);
        printer.finish();
        String expected = "      first       | last \n------------------+------\n a long line      | text \n without wrapping |      \n(1 row)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testAlignedPrintingNoRows() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestAlignedTablePrinter.column("first", "varchar")).add((Object)TestAlignedTablePrinter.column("last", "varchar")).build();
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        printer.finish();
        String expected = " first | last \n-------+------\n(0 rows)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testAlignedPrintingHex() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestAlignedTablePrinter.column("first", "varchar")).add((Object)TestAlignedTablePrinter.column("binary", "varbinary")).add((Object)TestAlignedTablePrinter.column("last", "varchar")).build();
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", TestAlignedTablePrinter.bytes("hello"), "world"), TestAlignedTablePrinter.row("a", TestAlignedTablePrinter.bytes("some long text that is more than 16 bytes"), "b"), TestAlignedTablePrinter.row("cat", TestAlignedTablePrinter.bytes(""), "dog")), true);
        printer.finish();
        String expected = " first |                     binary                      | last  \n-------+-------------------------------------------------+-------\n hello | 68 65 6c 6c 6f                                  | world \n a     | 73 6f 6d 65 20 6c 6f 6e 67 20 74 65 78 74 20 74+| b     \n       | 68 61 74 20 69 73 20 6d 6f 72 65 20 74 68 61 6e+|       \n       | 20 31 36 20 62 79 74 65 73                      |       \n cat   |                                                 | dog   \n(3 rows)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testAlignedPrintingWideCharacters() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestAlignedTablePrinter.column("go\u7f51", "varchar")).add((Object)TestAlignedTablePrinter.column("last", "varchar")).add((Object)TestAlignedTablePrinter.column("quantity\u7f51", "bigint")).build();
        StringWriter writer = new StringWriter();
        AlignedTablePrinter printer = new AlignedTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", "wide\u7f51", 123), TestAlignedTablePrinter.row("some long\ntext \u7f51\ndoes not\u7f51\nfit", "more\ntext", 4567), TestAlignedTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = "    go\u7f51    |  last  | quantity\u7f51 \n------------+--------+------------\n hello      | wide\u7f51 |        123 \n some long +| more  +|       4567 \n text \u7f51   +| text   |            \n does not\u7f51+|        |            \n fit        |        |            \n bye        | done   |        -15 \n(3 rows)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    static Column column(String name, String type) {
        return new Column(name, type, new ClientTypeSignature(type));
    }

    static List<?> row(Object ... values) {
        return Arrays.asList(values);
    }

    static Map<?, ?> map(KeyValue ... values) {
        return Arrays.stream(values).collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
    }

    static KeyValue item(Object key, Object value) {
        return new KeyValue(key, value);
    }

    static List<List<?>> rows(List<?> ... rows) {
        return Arrays.asList(rows);
    }

    static byte[] bytes(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    static class KeyValue {
        private final Object key;
        private final Object value;

        KeyValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

