/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.AutoTablePrinter;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAutoTablePrinter {
    @Test
    public void testNarrowPrinting() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestAutoTablePrinter.column("first", "varchar")).add((Object)TestAutoTablePrinter.column("last", "varchar")).add((Object)TestAutoTablePrinter.column("quantity", "bigint")).build();
        StringWriter writer = new StringWriter();
        AutoTablePrinter printer = new AutoTablePrinter((List)columns, (Writer)writer, 100);
        printer.printRows(TestAutoTablePrinter.rows(TestAutoTablePrinter.row("hello", "world", 123), TestAutoTablePrinter.row("a", null, 4.5), TestAutoTablePrinter.row("b", null, null), TestAutoTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = " first | last  | quantity \n-------+-------+----------\n hello | world |      123 \n a     | NULL  |      4.5 \n b     | NULL  |     NULL \n bye   | done  |      -15 \n(4 rows)\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testWidePrinting() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList columns = ImmutableList.builder().add((Object)TestAutoTablePrinter.column("first", "varchar")).add((Object)TestAutoTablePrinter.column("last", "varchar")).add((Object)TestAutoTablePrinter.column("quantity", "bigint")).build();
        AutoTablePrinter printer = new AutoTablePrinter((List)columns, (Writer)writer, 10);
        printer.printRows(TestAutoTablePrinter.rows(TestAutoTablePrinter.row("hello", "world", 123), TestAutoTablePrinter.row("a", null, 4.5), TestAutoTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]---\nfirst    | hello\nlast     | world\nquantity | 123\n-[ RECORD 2 ]---\nfirst    | a\nlast     | NULL\nquantity | 4.5\n-[ RECORD 3 ]---\nfirst    | bye\nlast     | done\nquantity | -15\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    static Column column(String name, String type) {
        return new Column(name, type, new ClientTypeSignature(type));
    }

    static List<?> row(Object ... values) {
        return Arrays.asList(values);
    }

    static List<List<?>> rows(List<?> ... rows) {
        return Arrays.asList(rows);
    }
}

