/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.cli.ClientOptions;
import io.trino.cli.Console;
import io.trino.cli.Trino;
import io.trino.client.ClientSession;
import io.trino.client.uri.TrinoUri;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClientOptions {
    @Test
    public void testDefaults() {
        Console console = TestClientOptions.createConsole(new String[0]);
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((Optional)options.krb5ServicePrincipalPattern).isEqualTo(Optional.of("${SERVICE}@${HOST}"));
        ClientSession session = options.toClientSession(options.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)session.getSource()).isEqualTo("trino-cli");
        Assertions.assertThat((Object)session.getTimeZone()).isEqualTo((Object)ZoneId.systemDefault());
    }

    @Test
    public void testSource() {
        Console console = TestClientOptions.createConsole("--source=test");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getSource()).isEqualTo("test");
    }

    @Test
    public void testTraceToken() {
        Console console = TestClientOptions.createConsole("--trace-token", "test token");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((Optional)session.getTraceToken()).isEqualTo(Optional.of("test token"));
    }

    @Test
    public void testServerHostOnly() {
        Console console = TestClientOptions.createConsole("--server=test");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://test:80");
    }

    @Test
    public void testServerHostPort() {
        Console console = TestClientOptions.createConsole("--server=test:8888");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://test:8888");
    }

    @Test
    public void testServerHttpUri() {
        Console console = TestClientOptions.createConsole("--server=http://test/foo");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://test:80");
        Assertions.assertThat((Optional)session.getCatalog()).isEqualTo(Optional.of("foo"));
    }

    @Test
    public void testServerTrinoUri() {
        Console console = TestClientOptions.createConsole("--server=trino://test/foo");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://test:80");
        Assertions.assertThat((Optional)session.getCatalog()).isEqualTo(Optional.of("foo"));
    }

    @Test
    public void testServerHttpsUri() {
        Console console = TestClientOptions.createConsole("--server=https://test/foo");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("https://test:443");
        Assertions.assertThat((Optional)session.getCatalog()).isEqualTo(Optional.of("foo"));
    }

    @Test
    public void testServer443Port() {
        Console console = TestClientOptions.createConsole("--server=test:443");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("https://test:443");
    }

    @Test
    public void testServerHttpsHostPort() {
        Console console = TestClientOptions.createConsole("--server=https://test:443");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("https://test:443");
    }

    @Test
    public void testServerHttpWithPort443() {
        Console console = TestClientOptions.createConsole("--server=http://test:443");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://test:443");
    }

    @Test
    public void testInvalidServer() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Console console = TestClientOptions.createConsole("--server=x:y");
            console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unparseable port number: x:y");
    }

    @Test
    public void testServerAndURL() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Console console = TestClientOptions.createConsole("--server=trino://server.example:80", "trino://server.example:80");
            console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Using both the URL parameter and the --server option is not allowed");
    }

    @Test
    public void testPath() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Console console = TestClientOptions.createConsole("--path=name.name.name");
            console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        }).isInstanceOf(RuntimeException.class)).hasMessage("Connection property 'path' has invalid syntax, should be [catalog].[schema] or [schema]");
        Console console = TestClientOptions.createConsole("--path=catalog.schema");
        TrinoUri trinoUri = console.clientOptions.getTrinoUri();
        Assertions.assertThat((Optional)trinoUri.getPath()).hasValue((Object)ImmutableList.of((Object)"catalog.schema"));
        Assertions.assertThat((List)console.clientOptions.toClientSession(trinoUri).getPath()).isEqualTo((Object)ImmutableList.of((Object)"catalog.schema"));
    }

    @Test
    public void testURLHostOnly() {
        Console console = TestClientOptions.createConsole("test");
        ClientSession session = console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://test:80");
    }

    @Test
    public void testURLParams() {
        Console console = TestClientOptions.createConsole("trino://server.example:8080/my-catalog/my-schema?source=my-client");
        TrinoUri uri = console.clientOptions.getTrinoUri();
        ClientSession session = console.clientOptions.toClientSession(uri);
        Assertions.assertThat((String)session.getServer().toString()).isEqualTo("http://server.example:8080");
        Assertions.assertThat((Optional)session.getCatalog()).isEqualTo(Optional.of("my-catalog"));
        Assertions.assertThat((Optional)session.getSchema()).isEqualTo(Optional.of("my-schema"));
        Assertions.assertThat((Optional)uri.getSource()).isEqualTo(Optional.of("my-client"));
    }

    @Test
    public void testURLPassword() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Console console = TestClientOptions.createConsole("trino://server.example:80?password=invalid");
            console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Setting the password in the URL parameter is not allowed.*");
    }

    @Test
    public void testOutputFormat() {
        Console console = TestClientOptions.createConsole("--output-format=JSON");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((Comparable)options.outputFormat).isEqualTo((Object)ClientOptions.OutputFormat.JSON);
    }

    @Test
    public void testSocksProxy() {
        Console console = TestClientOptions.createConsole("--socks-proxy=abc:123");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((Optional)options.socksProxy).isEqualTo(Optional.of(HostAndPort.fromParts((String)"abc", (int)123)));
    }

    @Test
    public void testClientRequestTimeout() {
        Console console = TestClientOptions.createConsole("--client-request-timeout=7s");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((Comparable)options.clientRequestTimeout).isEqualTo((Object)new Duration(7.0, TimeUnit.SECONDS));
    }

    @Test
    public void testResourceEstimates() {
        Console console = TestClientOptions.createConsole("--resource-estimate", "resource1=1B", "--resource-estimate", "resource2=2.2h");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((List)options.resourceEstimates).isEqualTo((Object)ImmutableList.of((Object)new ClientOptions.ClientResourceEstimate("resource1", "1B"), (Object)new ClientOptions.ClientResourceEstimate("resource2", "2.2h")));
    }

    @Test
    public void testExtraCredentials() {
        Console console = TestClientOptions.createConsole("--extra-credential", "test.token.foo=foo", "--extra-credential", "test.token.bar=bar");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((List)options.extraCredentials).isEqualTo((Object)ImmutableList.of((Object)new ClientOptions.ClientExtraCredential("test.token.foo", "foo"), (Object)new ClientOptions.ClientExtraCredential("test.token.bar", "bar")));
    }

    @Test
    public void testSessionProperties() {
        Console console = TestClientOptions.createConsole("--session", "system=system-value", "--session", "catalog.name=catalog-property");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((List)options.sessionProperties).isEqualTo((Object)ImmutableList.of((Object)new ClientOptions.ClientSessionProperty(Optional.empty(), "system", "system-value"), (Object)new ClientOptions.ClientSessionProperty(Optional.of("catalog"), "name", "catalog-property")));
        Assertions.assertThat((Object)new ClientOptions.ClientSessionProperty("foo=bar:=baz")).isEqualTo((Object)new ClientOptions.ClientSessionProperty(Optional.empty(), "foo", "bar:=baz"));
        Assertions.assertThat((Object)new ClientOptions.ClientSessionProperty("foo=")).isEqualTo((Object)new ClientOptions.ClientSessionProperty(Optional.empty(), "foo", ""));
    }

    @Test
    public void testTimeZone() {
        Console console = TestClientOptions.createConsole("--timezone=Europe/Vilnius");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((Object)options.timeZone).isEqualTo((Object)ZoneId.of("Europe/Vilnius"));
        ClientSession session = options.toClientSession(options.getTrinoUri());
        Assertions.assertThat((Object)session.getTimeZone()).isEqualTo((Object)ZoneId.of("Europe/Vilnius"));
    }

    @Test
    public void testTimeout() {
        Console console = TestClientOptions.createConsole("--client-request-timeout=17s");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((Comparable)options.clientRequestTimeout).isEqualTo((Object)Duration.succinctDuration((double)17.0, (TimeUnit)TimeUnit.SECONDS));
        ClientSession session = options.toClientSession(options.getTrinoUri());
        Assertions.assertThat((Comparable)session.getClientRequestTimeout()).isEqualTo((Object)Duration.succinctDuration((double)17.0, (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertThatThrownBy(() -> TestClientOptions.createConsole((String[])new String[]{"--client-request-timeout=17s", "trino://localhost:8080?timeout=30s"}).clientOptions.getTrinoUri()).hasMessageContaining("Connection property timeout is passed both by URL and properties");
    }

    @Test
    public void testDisableCompression() {
        Console console = TestClientOptions.createConsole("--disable-compression");
        ClientOptions options = console.clientOptions;
        Assertions.assertThat((boolean)options.disableCompression).isTrue();
        ClientSession session = options.toClientSession(options.getTrinoUri());
        Assertions.assertThat((boolean)session.isCompressionDisabled()).isTrue();
    }

    @Test
    public void testThreePartPropertyName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ClientOptions.ClientSessionProperty("foo.bar.baz=value")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid session property: foo.bar.baz=value");
    }

    @Test
    public void testEmptyPropertyName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ClientOptions.ClientSessionProperty("=value")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Session property name is empty");
    }

    @Test
    public void testInvalidCharsetPropertyName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ClientOptions.ClientSessionProperty("\u2603=value")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Session property name contains spaces or is not ASCII: \u2603");
    }

    @Test
    public void testInvalidCharsetPropertyValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ClientOptions.ClientSessionProperty("name=\u2603")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Session property value contains spaces or is not ASCII: \u2603");
    }

    @Test
    public void testEqualSignNoAllowedInPropertyCatalog() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ClientOptions.ClientSessionProperty(Optional.of("cat=alog"), "name", "value")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Session property catalog must not contain '=': name");
    }

    @Test
    public void testDuplicateExtraCredentialKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Console console = TestClientOptions.createConsole("--extra-credential", "test.token.foo=foo", "--extra-credential", "test.token.foo=bar");
            console.clientOptions.toClientSession(console.clientOptions.getTrinoUri());
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Multiple entries with same key: test.token.foo=bar and test.token.foo=foo");
    }

    @Test
    public void testAllClientOptionsHaveMappingToAConnectionProperty() {
        Set fieldsWithoutMapping = (Set)Arrays.stream(ClientOptions.class.getDeclaredFields()).filter(field -> Modifier.isPublic(field.getModifiers())).filter(field -> field.getAnnotation(ClientOptions.PropertyMapping.class) == null).map(Field::getName).filter(value -> !this.isCliSpecificOptions((String)value)).collect(ImmutableSet.toImmutableSet());
        Assertions.assertThat((Collection)fieldsWithoutMapping).isEmpty();
    }

    private boolean isCliSpecificOptions(String name) {
        switch (name) {
            case "url": 
            case "server": 
            case "file": 
            case "debug": 
            case "historyFile": 
            case "progress": 
            case "execute": 
            case "outputFormat": 
            case "outputFormatInteractive": 
            case "pager": 
            case "ignoreErrors": 
            case "editingMode": 
            case "disableAutoSuggestion": 
            case "decimalDataSize": {
                return true;
            }
        }
        return false;
    }

    private static Console createConsole(String ... args) {
        Console console = new Console();
        Trino.createCommandLine((Object)console).setDefaultValueProvider(null).parseArgs(args);
        return console;
    }
}

