/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.CsvPrinter;
import io.trino.cli.OutputPrinter;
import io.trino.cli.TestAlignedTablePrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCsvPrinter {
    @Test
    public void testCsvPrinting() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.STANDARD);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5), TestAlignedTablePrinter.row("some long\ntext that\ndoes not\nfit on\none line", "more\ntext", 4567), TestAlignedTablePrinter.row("bye", "done", -15));
        printer.finish();
        String expected = "\"first\",\"last\",\"quantity\"\n\"hello\",\"world\",\"123\"\n\"a\",\"\",\"4.5\"\n\"some long\ntext that\ndoes not\nfit on\none line\",\"more\ntext\",\"4567\"\n\"bye\",\"done\",\"-15\"\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvPrintingNoRows() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.STANDARD);
        printer.finish();
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo("\"first\",\"last\"\n");
    }

    @Test
    public void testCsvPrintingNoHeader() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.NO_HEADER);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5));
        printer.finish();
        String expected = "\"hello\",\"world\",\"123\"\n\"a\",\"\",\"4.5\"\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvPrintingWithoutQuotes() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.NO_QUOTES);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5), TestAlignedTablePrinter.row("\"quote\"", null, 2137));
        printer.finish();
        String expected = "first,last,quantity\nhello,world,123\na,,4.5\n\"quote\",,2137\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvPrintingNoRowsWithoutQuotes() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.NO_QUOTES);
        printer.finish();
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo("first,last\n");
    }

    @Test
    public void testCsvPrintingNoHeaderWithoutQuotes() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.NO_HEADER_AND_QUOTES);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5));
        printer.finish();
        String expected = "hello,world,123\na,,4.5\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvPrintingNoRowsWithNoHeaderAndWithoutQuotes() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.NO_HEADER_AND_QUOTES);
        printer.finish();
        String expected = "";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvVarbinaryPrinting() throws IOException {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.NO_HEADER);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row("hello".getBytes(StandardCharsets.UTF_8), null, 123));
        printer.finish();
        String expected = "\"68 65 6c 6c 6f\",\"\",\"123\"\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvVarbinaryInMaps() throws IOException {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"map", (Object)"value");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.STANDARD);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row(TestAlignedTablePrinter.map(TestAlignedTablePrinter.item("key", "value".getBytes(StandardCharsets.UTF_8))), "value"));
        printer.finish();
        String expected = "\"map\",\"value\"\n\"{key=76 61 6c 75 65}\",\"value\"\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testCsvVarbinaryInList() throws IOException {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"list", (Object)"value");
        CsvPrinter printer = new CsvPrinter((List)fieldNames, (Writer)writer, CsvPrinter.CsvOutputFormat.STANDARD);
        TestCsvPrinter.printRows((OutputPrinter)printer, TestAlignedTablePrinter.row(ImmutableList.of((Object)"value".getBytes(StandardCharsets.UTF_8)), "value"));
        printer.finish();
        String expected = "\"list\",\"value\"\n\"[76 61 6c 75 65]\",\"value\"\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    private static void printRows(OutputPrinter printer, List<?> ... rows) throws IOException {
        printer.printRows(TestAlignedTablePrinter.rows(rows), true);
    }
}

