/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.cli.FormatUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFormatUtils {
    @Test
    public void testFormatCount() {
        Assertions.assertThat((String)FormatUtils.formatCount((long)1L)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCount((long)12L)).isEqualTo("12");
        Assertions.assertThat((String)FormatUtils.formatCount((long)123L)).isEqualTo("123");
        Assertions.assertThat((String)FormatUtils.formatCount((long)1234L)).isEqualTo("1.23K");
        Assertions.assertThat((String)FormatUtils.formatCount((long)12345L)).isEqualTo("12.3K");
        Assertions.assertThat((String)FormatUtils.formatCount((long)123456L)).isEqualTo("123K");
        Assertions.assertThat((String)FormatUtils.formatCount((long)1234567L)).isEqualTo("1.23M");
        Assertions.assertThat((String)FormatUtils.formatCount((long)12345678L)).isEqualTo("12.3M");
        Assertions.assertThat((String)FormatUtils.formatCount((long)123456789L)).isEqualTo("123M");
        Assertions.assertThat((String)FormatUtils.formatCount((long)1234567890L)).isEqualTo("1.23B");
        Assertions.assertThat((String)FormatUtils.formatCount((long)12345678901L)).isEqualTo("12.3B");
        Assertions.assertThat((String)FormatUtils.formatCount((long)123456789012L)).isEqualTo("123B");
        Assertions.assertThat((String)FormatUtils.formatCount((long)1234567890123L)).isEqualTo("1.23T");
        Assertions.assertThat((String)FormatUtils.formatCount((long)12345678901234L)).isEqualTo("12.3T");
        Assertions.assertThat((String)FormatUtils.formatCount((long)123456789012345L)).isEqualTo("123T");
        Assertions.assertThat((String)FormatUtils.formatCount((long)1234567890123456L)).isEqualTo("1.23Q");
        Assertions.assertThat((String)FormatUtils.formatCount((long)12345678901234567L)).isEqualTo("12.3Q");
        Assertions.assertThat((String)FormatUtils.formatCount((long)123456789012345678L)).isEqualTo("123Q");
        Assertions.assertThat((String)FormatUtils.formatCount((long)1234567890123456789L)).isEqualTo("1235Q");
    }

    @Test
    public void testFormatCountRate() {
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-10, (Duration)Duration.valueOf((String)"1ns"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-10, (Duration)Duration.valueOf((String)"1ns"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-9, (Duration)Duration.valueOf((String)"1ns"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-9, (Duration)Duration.valueOf((String)"1ns"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.5E-9, (Duration)Duration.valueOf((String)"1ns"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.5E-9, (Duration)Duration.valueOf((String)"1ns"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1ns"), (boolean)false)).isEqualTo("1000M");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1ns"), (boolean)true)).isEqualTo("1000M/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1ns"), (boolean)false)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1ns"), (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10ns"), (boolean)false)).isEqualTo("1000M");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10ns"), (boolean)true)).isEqualTo("1000M/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-7, (Duration)Duration.valueOf((String)"1us"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-7, (Duration)Duration.valueOf((String)"1us"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-6, (Duration)Duration.valueOf((String)"1us"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-6, (Duration)Duration.valueOf((String)"1us"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.5E-6, (Duration)Duration.valueOf((String)"1us"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.5E-6, (Duration)Duration.valueOf((String)"1us"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1us"), (boolean)false)).isEqualTo("1000K");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1us"), (boolean)true)).isEqualTo("1000K/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1us"), (boolean)false)).isEqualTo("10M");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1us"), (boolean)true)).isEqualTo("10M/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10us"), (boolean)false)).isEqualTo("1000K");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10us"), (boolean)true)).isEqualTo("1000K/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-4, (Duration)Duration.valueOf((String)"1ms"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0E-4, (Duration)Duration.valueOf((String)"1ms"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)0.001, (Duration)Duration.valueOf((String)"1ms"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)0.001, (Duration)Duration.valueOf((String)"1ms"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)0.0015, (Duration)Duration.valueOf((String)"1ms"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)0.0015, (Duration)Duration.valueOf((String)"1ms"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1ms"), (boolean)false)).isEqualTo("1000");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1ms"), (boolean)true)).isEqualTo("1000/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1ms"), (boolean)false)).isEqualTo("10K");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1ms"), (boolean)true)).isEqualTo("10K/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10ms"), (boolean)false)).isEqualTo("1000");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10ms"), (boolean)true)).isEqualTo("1000/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)0.1, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)0.1, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"10s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"10s"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.5, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.5, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10s"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)10.0, (Duration)Duration.valueOf((String)"10s"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1m"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1m"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)60.0, (Duration)Duration.valueOf((String)"1m"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)60.0, (Duration)Duration.valueOf((String)"1m"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)600.0, (Duration)Duration.valueOf((String)"1m"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)600.0, (Duration)Duration.valueOf((String)"1m"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)100.0, (Duration)Duration.valueOf((String)"10m"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)100.0, (Duration)Duration.valueOf((String)"10m"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)600.0, (Duration)Duration.valueOf((String)"10m"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)600.0, (Duration)Duration.valueOf((String)"10m"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)6000.0, (Duration)Duration.valueOf((String)"10m"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)6000.0, (Duration)Duration.valueOf((String)"10m"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1h"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1h"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)3600.0, (Duration)Duration.valueOf((String)"1h"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)3600.0, (Duration)Duration.valueOf((String)"1h"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)36000.0, (Duration)Duration.valueOf((String)"1h"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)36000.0, (Duration)Duration.valueOf((String)"1h"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)100.0, (Duration)Duration.valueOf((String)"10h"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)100.0, (Duration)Duration.valueOf((String)"10h"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)36000.0, (Duration)Duration.valueOf((String)"10h"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)36000.0, (Duration)Duration.valueOf((String)"10h"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)360000.0, (Duration)Duration.valueOf((String)"10h"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)360000.0, (Duration)Duration.valueOf((String)"10h"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1d"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"1d"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)86400.0, (Duration)Duration.valueOf((String)"1d"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)86400.0, (Duration)Duration.valueOf((String)"1d"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)864000.0, (Duration)Duration.valueOf((String)"1d"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)864000.0, (Duration)Duration.valueOf((String)"1d"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)86400.0, (Duration)Duration.valueOf((String)"10d"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)86400.0, (Duration)Duration.valueOf((String)"10d"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)864000.0, (Duration)Duration.valueOf((String)"10d"), (boolean)false)).isEqualTo("1");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)864000.0, (Duration)Duration.valueOf((String)"10d"), (boolean)true)).isEqualTo("1/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)8640000.0, (Duration)Duration.valueOf((String)"10d"), (boolean)false)).isEqualTo("10");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)8640000.0, (Duration)Duration.valueOf((String)"10d"), (boolean)true)).isEqualTo("10/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)Double.NaN, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)Double.NaN, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)Double.POSITIVE_INFINITY, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)Double.POSITIVE_INFINITY, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)Double.NEGATIVE_INFINITY, (Duration)Duration.valueOf((String)"1s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)Double.NEGATIVE_INFINITY, (Duration)Duration.valueOf((String)"1s"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"0s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)1.0, (Duration)Duration.valueOf((String)"0s"), (boolean)true)).isEqualTo("0/s");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)-1.0, (Duration)Duration.valueOf((String)"0s"), (boolean)false)).isEqualTo("0");
        Assertions.assertThat((String)FormatUtils.formatCountRate((double)-1.0, (Duration)Duration.valueOf((String)"0s"), (boolean)true)).isEqualTo("0/s");
    }

    @Test
    public void testFormatDataSizeBinary() {
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1L), (boolean)false, (boolean)false)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1L), (boolean)true, (boolean)false)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12L), (boolean)false, (boolean)false)).isEqualTo("12B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12L), (boolean)true, (boolean)false)).isEqualTo("12B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123L), (boolean)false, (boolean)false)).isEqualTo("123B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123L), (boolean)true, (boolean)false)).isEqualTo("123B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234L), (boolean)false, (boolean)false)).isEqualTo("1.21Ki");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234L), (boolean)true, (boolean)false)).isEqualTo("1.21KiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345L), (boolean)false, (boolean)false)).isEqualTo("12.1Ki");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345L), (boolean)true, (boolean)false)).isEqualTo("12.1KiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456L), (boolean)false, (boolean)false)).isEqualTo("121Ki");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456L), (boolean)true, (boolean)false)).isEqualTo("121KiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567L), (boolean)false, (boolean)false)).isEqualTo("1.18Mi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567L), (boolean)true, (boolean)false)).isEqualTo("1.18MiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678L), (boolean)false, (boolean)false)).isEqualTo("11.8Mi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678L), (boolean)true, (boolean)false)).isEqualTo("11.8MiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789L), (boolean)false, (boolean)false)).isEqualTo("118Mi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789L), (boolean)true, (boolean)false)).isEqualTo("118MiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890L), (boolean)false, (boolean)false)).isEqualTo("1.15Gi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890L), (boolean)true, (boolean)false)).isEqualTo("1.15GiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901L), (boolean)false, (boolean)false)).isEqualTo("11.5Gi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901L), (boolean)true, (boolean)false)).isEqualTo("11.5GiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012L), (boolean)false, (boolean)false)).isEqualTo("115Gi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012L), (boolean)true, (boolean)false)).isEqualTo("115GiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123L), (boolean)false, (boolean)false)).isEqualTo("1.12Ti");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123L), (boolean)true, (boolean)false)).isEqualTo("1.12TiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234L), (boolean)false, (boolean)false)).isEqualTo("11.2Ti");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234L), (boolean)true, (boolean)false)).isEqualTo("11.2TiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345L), (boolean)false, (boolean)false)).isEqualTo("112Ti");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345L), (boolean)true, (boolean)false)).isEqualTo("112TiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456L), (boolean)false, (boolean)false)).isEqualTo("1.1Pi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456L), (boolean)true, (boolean)false)).isEqualTo("1.1PiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234567L), (boolean)false, (boolean)false)).isEqualTo("11Pi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234567L), (boolean)true, (boolean)false)).isEqualTo("11PiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345678L), (boolean)false, (boolean)false)).isEqualTo("110Pi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345678L), (boolean)true, (boolean)false)).isEqualTo("110PiB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456789L), (boolean)false, (boolean)false)).isEqualTo("1097Pi");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456789L), (boolean)true, (boolean)false)).isEqualTo("1097PiB");
    }

    @Test
    public void testFormatDataSizeDecimal() {
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1L), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1L), (boolean)true, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12L), (boolean)false, (boolean)true)).isEqualTo("12B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12L), (boolean)true, (boolean)true)).isEqualTo("12B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123L), (boolean)false, (boolean)true)).isEqualTo("123B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123L), (boolean)true, (boolean)true)).isEqualTo("123B");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234L), (boolean)false, (boolean)true)).isEqualTo("1.23K");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234L), (boolean)true, (boolean)true)).isEqualTo("1.23KB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345L), (boolean)false, (boolean)true)).isEqualTo("12.3K");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345L), (boolean)true, (boolean)true)).isEqualTo("12.3KB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456L), (boolean)false, (boolean)true)).isEqualTo("123K");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456L), (boolean)true, (boolean)true)).isEqualTo("123KB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567L), (boolean)false, (boolean)true)).isEqualTo("1.23M");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567L), (boolean)true, (boolean)true)).isEqualTo("1.23MB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678L), (boolean)false, (boolean)true)).isEqualTo("12.3M");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678L), (boolean)true, (boolean)true)).isEqualTo("12.3MB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789L), (boolean)false, (boolean)true)).isEqualTo("123M");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789L), (boolean)true, (boolean)true)).isEqualTo("123MB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890L), (boolean)false, (boolean)true)).isEqualTo("1.23G");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890L), (boolean)true, (boolean)true)).isEqualTo("1.23GB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901L), (boolean)false, (boolean)true)).isEqualTo("12.3G");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901L), (boolean)true, (boolean)true)).isEqualTo("12.3GB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012L), (boolean)false, (boolean)true)).isEqualTo("123G");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012L), (boolean)true, (boolean)true)).isEqualTo("123GB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123L), (boolean)false, (boolean)true)).isEqualTo("1.23T");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123L), (boolean)true, (boolean)true)).isEqualTo("1.23TB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234L), (boolean)false, (boolean)true)).isEqualTo("12.3T");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234L), (boolean)true, (boolean)true)).isEqualTo("12.3TB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345L), (boolean)false, (boolean)true)).isEqualTo("123T");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345L), (boolean)true, (boolean)true)).isEqualTo("123TB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456L), (boolean)false, (boolean)true)).isEqualTo("1.23P");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456L), (boolean)true, (boolean)true)).isEqualTo("1.23PB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234567L), (boolean)false, (boolean)true)).isEqualTo("12.3P");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)12345678901234567L), (boolean)true, (boolean)true)).isEqualTo("12.3PB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345678L), (boolean)false, (boolean)true)).isEqualTo("123P");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)123456789012345678L), (boolean)true, (boolean)true)).isEqualTo("123PB");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456789L), (boolean)false, (boolean)true)).isEqualTo("1235P");
        Assertions.assertThat((String)FormatUtils.formatDataSize((DataSize)DataSize.ofBytes((long)1234567890123456789L), (boolean)true, (boolean)true)).isEqualTo("1235PB");
    }

    @Test
    public void testFormatDataRateBinary() {
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ns"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ns"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ns"), (boolean)false, (boolean)true)).isEqualTo("1G");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ns"), (boolean)true, (boolean)true)).isEqualTo("1GB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ns"), (boolean)false, (boolean)true)).isEqualTo("10G");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ns"), (boolean)true, (boolean)true)).isEqualTo("10GB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ns"), (boolean)false, (boolean)true)).isEqualTo("1G");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ns"), (boolean)true, (boolean)true)).isEqualTo("1GB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1us"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1us"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1us"), (boolean)false, (boolean)true)).isEqualTo("1M");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1us"), (boolean)true, (boolean)true)).isEqualTo("1MB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1us"), (boolean)false, (boolean)true)).isEqualTo("10M");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1us"), (boolean)true, (boolean)true)).isEqualTo("10MB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10us"), (boolean)false, (boolean)true)).isEqualTo("1M");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10us"), (boolean)true, (boolean)true)).isEqualTo("1MB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ms"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ms"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ms"), (boolean)false, (boolean)true)).isEqualTo("1K");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ms"), (boolean)true, (boolean)true)).isEqualTo("1KB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ms"), (boolean)false, (boolean)true)).isEqualTo("10K");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ms"), (boolean)true, (boolean)true)).isEqualTo("10KB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ms"), (boolean)false, (boolean)true)).isEqualTo("1K");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ms"), (boolean)true, (boolean)true)).isEqualTo("1KB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1s"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1s"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1s"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1s"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"10s"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"10s"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1s"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1s"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10s"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10s"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1m"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1m"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)60L), (Duration)Duration.valueOf((String)"1m"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)60L), (Duration)Duration.valueOf((String)"1m"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"1m"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"1m"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10m"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10m"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"10m"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"10m"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)6000L), (Duration)Duration.valueOf((String)"10m"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)6000L), (Duration)Duration.valueOf((String)"10m"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1h"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1h"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)3600L), (Duration)Duration.valueOf((String)"1h"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)3600L), (Duration)Duration.valueOf((String)"1h"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"1h"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"1h"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10h"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10h"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"10h"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"10h"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)360000L), (Duration)Duration.valueOf((String)"10h"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)360000L), (Duration)Duration.valueOf((String)"10h"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1d"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1d"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"1d"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"1d"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"1d"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"1d"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"10d"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"10d"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"10d"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"10d"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)8640000L), (Duration)Duration.valueOf((String)"10d"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)8640000L), (Duration)Duration.valueOf((String)"10d"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
    }

    @Test
    public void testFormatDataRateDecimal() {
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ns"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ns"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ns"), (boolean)false, (boolean)true)).isEqualTo("1G");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ns"), (boolean)true, (boolean)true)).isEqualTo("1GB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ns"), (boolean)false, (boolean)true)).isEqualTo("10G");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ns"), (boolean)true, (boolean)true)).isEqualTo("10GB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ns"), (boolean)false, (boolean)true)).isEqualTo("1G");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ns"), (boolean)true, (boolean)true)).isEqualTo("1GB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1us"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1us"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1us"), (boolean)false, (boolean)true)).isEqualTo("1M");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1us"), (boolean)true, (boolean)true)).isEqualTo("1MB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1us"), (boolean)false, (boolean)true)).isEqualTo("10M");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1us"), (boolean)true, (boolean)true)).isEqualTo("10MB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10us"), (boolean)false, (boolean)true)).isEqualTo("1M");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10us"), (boolean)true, (boolean)true)).isEqualTo("1MB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ms"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1ms"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ms"), (boolean)false, (boolean)true)).isEqualTo("1K");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1ms"), (boolean)true, (boolean)true)).isEqualTo("1KB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ms"), (boolean)false, (boolean)true)).isEqualTo("10K");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1ms"), (boolean)true, (boolean)true)).isEqualTo("10KB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ms"), (boolean)false, (boolean)true)).isEqualTo("1K");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10ms"), (boolean)true, (boolean)true)).isEqualTo("1KB/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1s"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)0L), (Duration)Duration.valueOf((String)"1s"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1s"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1s"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"10s"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"10s"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1s"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"1s"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10s"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)10L), (Duration)Duration.valueOf((String)"10s"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1m"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1m"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)60L), (Duration)Duration.valueOf((String)"1m"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)60L), (Duration)Duration.valueOf((String)"1m"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"1m"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"1m"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10m"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10m"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"10m"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)600L), (Duration)Duration.valueOf((String)"10m"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)6000L), (Duration)Duration.valueOf((String)"10m"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)6000L), (Duration)Duration.valueOf((String)"10m"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1h"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1h"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)3600L), (Duration)Duration.valueOf((String)"1h"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)3600L), (Duration)Duration.valueOf((String)"1h"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"1h"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"1h"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10h"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)100L), (Duration)Duration.valueOf((String)"10h"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"10h"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)36000L), (Duration)Duration.valueOf((String)"10h"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)360000L), (Duration)Duration.valueOf((String)"10h"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)360000L), (Duration)Duration.valueOf((String)"10h"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1d"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"1d"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"1d"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"1d"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"1d"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"1d"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"10d"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)86400L), (Duration)Duration.valueOf((String)"10d"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"10d"), (boolean)false, (boolean)true)).isEqualTo("1B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)864000L), (Duration)Duration.valueOf((String)"10d"), (boolean)true, (boolean)true)).isEqualTo("1B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)8640000L), (Duration)Duration.valueOf((String)"10d"), (boolean)false, (boolean)true)).isEqualTo("10B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)8640000L), (Duration)Duration.valueOf((String)"10d"), (boolean)true, (boolean)true)).isEqualTo("10B/s");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"0s"), (boolean)false, (boolean)true)).isEqualTo("0B");
        Assertions.assertThat((String)FormatUtils.formatDataRate((DataSize)DataSize.ofBytes((long)1L), (Duration)Duration.valueOf((String)"0s"), (boolean)true, (boolean)true)).isEqualTo("0B/s");
    }

    @Test
    public void testPluralize() {
        Assertions.assertThat((String)FormatUtils.pluralize((String)"foo", (int)0)).isEqualTo("foos");
        Assertions.assertThat((String)FormatUtils.pluralize((String)"foo", (int)1)).isEqualTo("foo");
        Assertions.assertThat((String)FormatUtils.pluralize((String)"foo", (int)2)).isEqualTo("foos");
    }

    @Test
    public void testFormatFinalTime() {
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0us"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0ns"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0ms"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0s"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0m"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0h"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"0d"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1us"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1ns"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1ms"))).isEqualTo("0.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"10ms"))).isEqualTo("0.01");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"100ms"))).isEqualTo("0.10");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1s"))).isEqualTo("1.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"10s"))).isEqualTo("10.00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1m"))).isEqualTo("1:00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"61s"))).isEqualTo("1:01");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1h"))).isEqualTo("60:00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"61m"))).isEqualTo("61:00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"1d"))).isEqualTo("1440:00");
        Assertions.assertThat((String)FormatUtils.formatFinalTime((Duration)Duration.valueOf((String)"25h"))).isEqualTo("1500:00");
    }

    @Test
    public void testFormatIndeterminateProgressBar() {
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)0)).isEqualTo("<=>       ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)1)).isEqualTo(" <=>      ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)7)).isEqualTo("       <=>");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)8)).isEqualTo("      <=> ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)13)).isEqualTo(" <=>      ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)14)).isEqualTo("<=>       ");
    }

    @Test
    public void testInvalidIndeterminateProgressBar() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FormatUtils.formatProgressBar((int)10, (int)-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("invalid count: -1");
    }

    @Test
    public void testFormatProgressBar() {
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)0, (int)0)).isEqualTo("          ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)10, (int)10)).isEqualTo("=>        ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)10, (int)20)).isEqualTo("=>>       ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)20, (int)10)).isEqualTo("==>       ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)20, (int)20)).isEqualTo("==>>      ");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)50, (int)50)).isEqualTo("=====>>>>>");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)100, (int)0)).isEqualTo("==========");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)0, (int)100)).isEqualTo(">>>>>>>>>>");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)60, (int)60)).isEqualTo("======>>>>");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)120, (int)0)).isEqualTo("==========");
        Assertions.assertThat((String)FormatUtils.formatProgressBar((int)10, (int)0, (int)120)).isEqualTo(">>>>>>>>>>");
    }

    @Test
    public void testInvalidProgressBar() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FormatUtils.formatProgressBar((int)10, (int)-100, (int)0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid count: -9");
    }
}

