/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.io.Resources;
import io.trino.cli.ClientOptions;
import io.trino.cli.Query;
import io.trino.cli.QueryRunner;
import io.trino.cli.TerminalUtils;
import io.trino.cli.TestQueryRunner;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestInsecureQueryRunner {
    private MockWebServer server;

    @BeforeEach
    public void setup() throws Exception {
        this.server = new MockWebServer();
        SSLContext sslContext = this.buildTestSslContext();
        this.server.useHttps(sslContext.getSocketFactory(), false);
        this.server.start();
    }

    @AfterEach
    public void teardown() throws Exception {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testInsecureConnection() throws Exception {
        this.server.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(TestQueryRunner.createResults(this.server)));
        this.server.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(TestQueryRunner.createResults(this.server)));
        QueryRunner queryRunner = TestQueryRunner.createQueryRunner(TestQueryRunner.createTrinoUri(this.server, true), TestQueryRunner.createClientSession(this.server));
        try (Query query = queryRunner.startQuery("query with insecure mode");){
            query.renderOutput(TerminalUtils.getTerminal(), TestQueryRunner.nullPrintStream(), TestQueryRunner.nullPrintStream(), ClientOptions.OutputFormat.CSV, Optional.of(""), false, false);
        }
        Assertions.assertThat((String)this.server.takeRequest().getPath()).isEqualTo("/v1/statement");
    }

    private SSLContext buildTestSslContext() throws Exception {
        char[] serverKeyStorePassword = "insecure-ssl-test".toCharArray();
        KeyStore serverKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream in = Resources.getResource(this.getClass(), (String)"/insecure-ssl-test.jks").openStream();){
            serverKeyStore.load(in, serverKeyStorePassword);
        }
        String kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
        kmf.init(serverKeyStore, serverKeyStorePassword);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(kmfAlgorithm);
        trustManagerFactory.init(serverKeyStore);
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(kmf.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }
}

