/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.JsonPrinter;
import io.trino.cli.TestAlignedTablePrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonPrinter {
    @Test
    public void testJsonPrinting() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        JsonPrinter printer = new JsonPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5), TestAlignedTablePrinter.row("some long\ntext\tdone", "more\ntext", 4567), TestAlignedTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = "{\"first\":\"hello\",\"last\":\"world\",\"quantity\":123}\n{\"first\":\"a\",\"last\":null,\"quantity\":4.5}\n{\"first\":\"some long\\ntext\\tdone\",\"last\":\"more\\ntext\",\"quantity\":4567}\n{\"first\":\"bye\",\"last\":\"done\",\"quantity\":-15}\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testJsonPrintingNoRows() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last");
        JsonPrinter printer = new JsonPrinter((List)fieldNames, (Writer)writer);
        printer.finish();
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo("");
    }

    @Test
    public void testJsonVarbinaryPrinting() throws IOException {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        JsonPrinter printer = new JsonPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello".getBytes(StandardCharsets.UTF_8), null, 123)), true);
        printer.finish();
        String expected = "{\"first\":\"68 65 6c 6c 6f\",\"last\":null,\"quantity\":123}\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }
}

