/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.MarkdownTablePrinter;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMarkdownTablePrinter {
    @Test
    public void testMarkdownPrinting() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestMarkdownTablePrinter.column("first", "varchar")).add((Object)TestMarkdownTablePrinter.column("last", "varchar")).add((Object)TestMarkdownTablePrinter.column("quantity", "bigint")).build();
        StringWriter writer = new StringWriter();
        MarkdownTablePrinter printer = new MarkdownTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestMarkdownTablePrinter.rows(TestMarkdownTablePrinter.row("hello", "world", 123), TestMarkdownTablePrinter.row("a", null, 4.5), TestMarkdownTablePrinter.row("b", null, null), TestMarkdownTablePrinter.row("some long\ntext that\ndoes not\nfit on\none line", "more\ntext", 4567), TestMarkdownTablePrinter.row("bye | not **& <a>**", "done", -15)), true);
        printer.finish();
        String expected = "| first                                                    | last         | quantity |\n| -------------------------------------------------------- | ------------ | --------:|\n| hello                                                    | world        |      123 |\n| a                                                        | NULL         |      4.5 |\n| b                                                        | NULL         |     NULL |\n| some long<br>text that<br>does not<br>fit on<br>one line | more<br>text |     4567 |\n| bye \\| not \\*\\*& \\<a\\>\\*\\*                               | done         |      -15 |\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testMarkdownPrintingOneRow() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestMarkdownTablePrinter.column("first", "varchar")).add((Object)TestMarkdownTablePrinter.column("last", "varchar")).build();
        StringWriter writer = new StringWriter();
        MarkdownTablePrinter printer = new MarkdownTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestMarkdownTablePrinter.rows(TestMarkdownTablePrinter.row("a long line\nwithout wrapping", "text")), true);
        printer.finish();
        String expected = "| first                           | last |\n| ------------------------------- | ---- |\n| a long line<br>without wrapping | text |\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testMarkdownPrintingNoRows() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestMarkdownTablePrinter.column("first", "varchar")).add((Object)TestMarkdownTablePrinter.column("last", "varchar")).build();
        StringWriter writer = new StringWriter();
        MarkdownTablePrinter printer = new MarkdownTablePrinter((List)columns, (Writer)writer);
        printer.finish();
        String expected = "";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testMarkdownPrintingHex() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestMarkdownTablePrinter.column("first", "varchar")).add((Object)TestMarkdownTablePrinter.column("binary", "varbinary")).add((Object)TestMarkdownTablePrinter.column("last", "varchar")).build();
        StringWriter writer = new StringWriter();
        MarkdownTablePrinter printer = new MarkdownTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestMarkdownTablePrinter.rows(TestMarkdownTablePrinter.row("hello", TestMarkdownTablePrinter.bytes("hello"), "world"), TestMarkdownTablePrinter.row("a", TestMarkdownTablePrinter.bytes("some long text that is more than 16 bytes"), "b"), TestMarkdownTablePrinter.row("cat", TestMarkdownTablePrinter.bytes(""), "dog")), true);
        printer.finish();
        String expected = "| first | binary                                                                                                                           | last  |\n| ----- | -------------------------------------------------------------------------------------------------------------------------------- | ----- |\n| hello | 68 65 6c 6c 6f                                                                                                                   | world |\n| a     | 73 6f 6d 65 20 6c 6f 6e 67 20 74 65 78 74 20 74<br>68 61 74 20 69 73 20 6d 6f 72 65 20 74 68 61 6e<br>20 31 36 20 62 79 74 65 73 | b     |\n| cat   |                                                                                                                                  | dog   |\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testMarkdownPrintingWideCharacters() throws Exception {
        ImmutableList columns = ImmutableList.builder().add((Object)TestMarkdownTablePrinter.column("go\u7f51", "varchar")).add((Object)TestMarkdownTablePrinter.column("last", "varchar")).add((Object)TestMarkdownTablePrinter.column("quantity\u7f51", "bigint")).build();
        StringWriter writer = new StringWriter();
        MarkdownTablePrinter printer = new MarkdownTablePrinter((List)columns, (Writer)writer);
        printer.printRows(TestMarkdownTablePrinter.rows(TestMarkdownTablePrinter.row("hello", "wide\u7f51", 123), TestMarkdownTablePrinter.row("some long\ntext \u7f51\ndoes not\u7f51\nfit", "more\ntext", 4567), TestMarkdownTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = "| go\u7f51                                      | last         | quantity\u7f51 |\n| ----------------------------------------- | ------------ | ----------:|\n| hello                                     | wide\u7f51       |        123 |\n| some long<br>text \u7f51<br>does not\u7f51<br>fit | more<br>text |       4567 |\n| bye                                       | done         |        -15 |\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    static Column column(String name, String type) {
        return new Column(name, type, new ClientTypeSignature(type));
    }

    static List<?> row(Object ... values) {
        return Arrays.asList(values);
    }

    static List<List<?>> rows(List<?> ... rows) {
        return Arrays.asList(rows);
    }

    static byte[] bytes(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }
}

