/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.airlift.units.Duration;
import io.trino.cli.ClientOptions;
import io.trino.cli.Query;
import io.trino.cli.QueryRunner;
import io.trino.cli.TerminalUtils;
import io.trino.client.ClientSession;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.JsonCodec;
import io.trino.client.QueryResults;
import io.trino.client.StatementStats;
import io.trino.client.TypedQueryData;
import io.trino.client.auth.external.ExternalRedirectStrategy;
import io.trino.client.uri.PropertyName;
import io.trino.client.uri.TrinoUri;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestQueryRunner {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private MockWebServer server;

    @BeforeEach
    public void setup() throws IOException {
        this.server = new MockWebServer();
        this.server.start();
    }

    @AfterEach
    public void teardown() throws IOException {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testCookie() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(307).addHeader("Location", (Object)this.server.url("/v1/statement")).addHeader("Set-Cookie", (Object)"a=apple"));
        this.server.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(TestQueryRunner.createResults(this.server)));
        this.server.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(TestQueryRunner.createResults(this.server)));
        QueryRunner queryRunner = TestQueryRunner.createQueryRunner(TestQueryRunner.createTrinoUri(this.server, false), TestQueryRunner.createClientSession(this.server));
        try (Query query = queryRunner.startQuery("first query will introduce a cookie");){
            query.renderOutput(TerminalUtils.getTerminal(), TestQueryRunner.nullPrintStream(), TestQueryRunner.nullPrintStream(), ClientOptions.OutputFormat.CSV, Optional.of(""), false, false);
        }
        query = queryRunner.startQuery("second query should carry the cookie");
        try {
            query.renderOutput(TerminalUtils.getTerminal(), TestQueryRunner.nullPrintStream(), TestQueryRunner.nullPrintStream(), ClientOptions.OutputFormat.CSV, Optional.of(""), false, false);
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
        Assertions.assertThat((String)this.server.takeRequest().getHeader("Cookie")).isNull();
        Assertions.assertThat((String)this.server.takeRequest().getHeader("Cookie")).isEqualTo("a=apple");
        Assertions.assertThat((String)this.server.takeRequest().getHeader("Cookie")).isEqualTo("a=apple");
    }

    static TrinoUri createTrinoUri(MockWebServer server, boolean insecureSsl) {
        Properties properties = new Properties();
        properties.setProperty(PropertyName.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS.toString(), ExternalRedirectStrategy.PRINT.name());
        properties.setProperty(PropertyName.SSL.toString(), Boolean.toString(!insecureSsl));
        return TrinoUri.create((URI)server.url("/").uri(), (Properties)properties);
    }

    static ClientSession createClientSession(MockWebServer server) {
        return ClientSession.builder().server(server.url("/").uri()).user(Optional.of("user")).source("source").clientInfo("clientInfo").catalog("catalog").schema("schema").timeZone(ZoneId.of("America/Los_Angeles")).locale(Locale.ENGLISH).transactionId(null).clientRequestTimeout(new Duration(2.0, TimeUnit.MINUTES)).compressionDisabled(true).build();
    }

    static String createResults(MockWebServer server) {
        QueryResults queryResults = new QueryResults("20160128_214710_00012_rk68b", server.url("/query.html?20160128_214710_00012_rk68b").uri(), null, null, (List)ImmutableList.of((Object)new Column("_col0", "bigint", new ClientTypeSignature("bigint"))), TypedQueryData.of((Iterable)ImmutableList.of((Object)ImmutableList.of((Object)123))), StatementStats.builder().setState("FINISHED").setProgressPercentage(OptionalDouble.empty()).setRunningPercentage(OptionalDouble.empty()).build(), null, (List)ImmutableList.of(), null, null);
        return QUERY_RESULTS_CODEC.toJson((Object)queryResults);
    }

    static QueryRunner createQueryRunner(TrinoUri uri, ClientSession clientSession) {
        return new QueryRunner(uri, clientSession, false);
    }

    static PrintStream nullPrintStream() {
        return new PrintStream(ByteStreams.nullOutputStream());
    }
}

