/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.TestAlignedTablePrinter;
import io.trino.cli.TsvPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTsvPrinter {
    @Test
    public void testTsvPrinting() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        TsvPrinter printer = new TsvPrinter((List)fieldNames, (Writer)writer, true);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5), TestAlignedTablePrinter.row("some long\ntext\tdone", "more\ntext", 4567), TestAlignedTablePrinter.row("bye", "done", -15), TestAlignedTablePrinter.row("oops\u0000a\nb\rc\bd\fe\tf\\g\u0001done", "escape", 9)), true);
        printer.finish();
        String expected = "first\tlast\tquantity\nhello\tworld\t123\na\t\t4.5\nsome long\\ntext\\tdone\tmore\\ntext\t4567\nbye\tdone\t-15\noops\\0a\\nb\\rc\\bd\\fe\\tf\\\\g\u0001done\tescape\t9\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testTsvPrintingNoRows() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last");
        TsvPrinter printer = new TsvPrinter((List)fieldNames, (Writer)writer, true);
        printer.finish();
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo("first\tlast\n");
    }

    @Test
    public void testTsvPrintingNoHeader() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        TsvPrinter printer = new TsvPrinter((List)fieldNames, (Writer)writer, false);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5)), true);
        printer.finish();
        String expected = "hello\tworld\t123\na\t\t4.5\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testTsvVarbinaryPrinting() throws IOException {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        TsvPrinter printer = new TsvPrinter((List)fieldNames, (Writer)writer, false);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello".getBytes(StandardCharsets.UTF_8), null, 123)), true);
        printer.finish();
        String expected = "68 65 6c 6c 6f\t\t123\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }
}

